#ifndef SCORE_H
#define SCORE_H

#include "reversidefs.h"

class Score
{
public:
    enum score_type {WIN, LOSS, DRAW};
    Score();
    ~Score();

    void score(unsigned ai_level, unsigned *win, unsigned *loss, unsigned *draws) const
    {
        *win = score_[ai_level][WIN]; *loss = score_[ai_level][LOSS]; *draws = score_[ai_level][DRAW];
    }

    void incScore(unsigned ai_level, score_type s_type)
    {
        score_[ai_level][s_type]++;
    }

    void reset();

private:
    /**
      Array for number of wins, losses, draws for all AI levels
     */
    unsigned score_[NUM_AI_LEVELS][3];
};

#endif // SCORE_H
