#include "reversiitem.h"

#include "pixmaps/EmptyCell.xpm"
#include "pixmaps/WhiteCell.xpm"
#include "pixmaps/BlackCell.xpm"
#include "pixmaps/c01.xpm"
#include "pixmaps/c02.xpm"
#include "pixmaps/c03.xpm"
#include "pixmaps/c04.xpm"
#include "pixmaps/c05.xpm"
#include "pixmaps/c06.xpm"
#include "pixmaps/c07.xpm"
#include "pixmaps/c08.xpm"
#include "pixmaps/c09.xpm"
#include "pixmaps/c10.xpm"

PixmapsFactory::PixmapsFactory()
{
    chipPixmaps_[White] = QPixmap(WhiteCell_xpm);
    chipPixmaps_[Black] = QPixmap(BlackCell_xpm);
    chipPixmaps_[Empty] = QPixmap(EmptyCell_xpm);
    chipPixmaps_[3] = QPixmap(c01_xpm);
    chipPixmaps_[4] = QPixmap(c02_xpm);
    chipPixmaps_[5] = QPixmap(c03_xpm);
    chipPixmaps_[6] = QPixmap(c04_xpm);
    chipPixmaps_[7] = QPixmap(c05_xpm);
    chipPixmaps_[8] = QPixmap(c06_xpm);
    chipPixmaps_[9] = QPixmap(c07_xpm);
    chipPixmaps_[10] = QPixmap(c08_xpm);
    chipPixmaps_[11] = QPixmap(c09_xpm);
    chipPixmaps_[12] = QPixmap(c10_xpm);
}

ReversiItem::ReversiItem(QGraphicsScene *scene, PixmapsFactory *pixmapsFactory):
        QGraphicsPixmapItem(0, scene),
        pixmapsFactory_(pixmapsFactory)
{
    setColor(Empty);
}

void ReversiItem::setColor(int c)
{
    setPixmap(pixmapsFactory_->chipPixmaps_[c]);
}
