#ifndef REVERSISCENE_H
#define REVERSISCENE_H

#include <QGraphicsScene>

#include "reversidefs.h"

class ReversiGame;
class QWidget;
class QTimer;

class ReversiScene : public QGraphicsScene
{
    Q_OBJECT
public:
    ReversiScene(ReversiGame &reversiGame, QWidget *mainWin);
    ~ReversiScene();
    int fieldWidth() const { return fieldWidth_; }
    int fieldHeight() const { return fieldHeight_; }
    void setIsNetworkMode(bool mode) { isNetworkMode_ = mode;}

public slots:
    void syncBoard();

signals:
    void gameOver();
    //void stepUnavailable();
    void playerStep(int, int);

private:
    virtual void mouseReleaseEvent(QGraphicsSceneMouseEvent *event);

private slots:
    void slotStepComplete();
    void slotNewGame(bool);
    void slotAnimationStep();

private:
    ReversiGame &reversiGame_;
    ChipColor   currentPlayer_;

    int cellWidth_;
    int cellHeight_;
    int fieldWidth_;
    int fieldHeight_;
    bool isNetworkMode_;

    //variables for animation
    QTimer *animTimer_;
    int animCellStep_[CHIPS_COUNT];  //step of animation for one cell.
    int animDirection_;     // 1 - from white to black, -1 - from black to white
    int animFirstCell_;     // first animated cell
    int animLastCell_;      // last animated cell
};

#endif // REVERSISCENE_H
