#include <QGraphicsSceneMouseEvent>
#include <QWidget>

#include "reversiscene.h"
#include "reversiitem.h"
#include "reversidefs.h"
#include "reversigame.h"

ReversiScene::ReversiScene(ReversiGame &reversiGame, QWidget *mainWin):
        reversiGame_(reversiGame), cellWidth_(0), cellHeight_(0)
{
    for (unsigned i = 0; i < FIELDSIZE; ++i)
        for(unsigned j = 0; j < FIELDSIZE; j++)
        {
            ReversiItem *ri = new ReversiItem(this);
            if (!cellWidth_) cellWidth_ = ri->width();
            if (!cellHeight_) cellHeight_ = ri->height();
            ri->setPos(i * cellWidth_, j * cellHeight_);
        }

    fieldWidth_ = FIELDSIZE * cellWidth_;
    fieldHeight_ = FIELDSIZE * cellHeight_;

    connect(&reversiGame_, SIGNAL(stepComplete()), SLOT(slotStepComplete()));
    connect(&reversiGame_, SIGNAL(newGame()), SLOT(slotNewGame()));
    mainWin->connect(this, SIGNAL(stepUnavailable()), mainWin, SLOT(stepUnavailable()));
}

void ReversiScene::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)
{
    int x = int(event->scenePos().x() / cellWidth_);
    int y = int(event->scenePos().y() / cellHeight_);
    currentPlayer_ = reversiGame_.currentPlayer();
    reversiGame_.makeStep(x, y);
}

void ReversiScene::slotNewGame()
{
    currentPlayer_ = reversiGame_.currentPlayer();
    syncBoard();
}

void ReversiScene::syncBoard()
{
    for (unsigned i = 0; i < FIELDSIZE; ++i)
        for(unsigned j = 0; j < FIELDSIZE; j++)
        {
            ReversiItem *it = static_cast<ReversiItem*>(itemAt(i * cellWidth_, j * cellHeight_));
            it->setColor(reversiGame_.chipColor(i, j));
        }
    update(0, 0, fieldWidth_, fieldHeight_);
}

void ReversiScene::slotStepComplete()
{
    const QList<QPoint> &changedCells = reversiGame_.changedCells();
    for(int i = 0; i < changedCells.size(); ++i)
    {
        int x = changedCells.at(i).x();
        int y = changedCells.at(i).y();
        ReversiItem *it = static_cast<ReversiItem*>(itemAt(x * cellWidth_, y * cellHeight_));
        currentPlayer_ = reversiGame_.opponentPlayer();
        it->setColor(currentPlayer_);
        update(x * cellWidth_, y * cellHeight_, cellWidth_, cellHeight_);
    }//for

    reversiGame_.startNextTurn();
}//slotStepComplete
