#include "mainwindow.h"
#include <QtNetwork/QNetworkRequest>
#include <QtNetwork/QNetworkCookie>

#ifdef Q_WS_MAEMO_5
#include <QMaemo5InformationBox>
#endif

QString serializeCookies(QList<QNetworkCookie> cookies) {
    QString ret = "";
    foreach (QNetworkCookie cookie, cookies) {
        ret += cookie.name() + "|" + cookie.value();
        ret += "#";
    }
    ret.replace(QRegExp("#$"), "");
    return ret;
}

QList<QNetworkCookie> deserializeCookies(QString stringCookies) {
    QStringList cookieList = stringCookies.split("#");
    QList<QNetworkCookie> ret;
    foreach (QString stringCookie, cookieList) {
        QStringList keyValue = stringCookie.split("|");
        if (keyValue.length() == 2) {
            QNetworkCookie c(keyValue[0].toAscii(),keyValue[1].toAscii());
            ret.append(c);
        }
    }
    return ret;
}

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent)
{
    cookiejarGoogleTasks = new QNetworkCookieJar(this);
    QSettings settings("mobileqt.de", "QtGoogleTasks");
    QList<QNetworkCookie> cookieList = deserializeCookies(settings.value("cookieJar", "").toString());
    cookiejarGoogleTasks->setCookiesFromUrl(cookieList, QUrl("https://mail.google.com/tasks/ig"));

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif

    createMenu();
    createComponents();
    createLayout();
    selfAssignLayout();
    createConnects();
    retranslateUi();
}

void MainWindow::createMenu()
{
    actionAbout = new QAction(this);

    QMenuBar * menuBar = new QMenuBar(this);
    menuBar->addAction(actionAbout);
    setMenuBar(menuBar);
}

void MainWindow::createComponents()
{
    webviewGoogleTasks = new QWebView();
    webviewGoogleTasks->page()->networkAccessManager()->setCookieJar(cookiejarGoogleTasks);
    webviewGoogleTasks->setZoomFactor(1.8f);;
#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox::information(this, tr("Loading Google Tasks"),
        QMaemo5InformationBox::DefaultTimeout);
#endif
    webviewGoogleTasks->load(QUrl("https://mail.google.com/tasks/ig"));
}

void MainWindow::createConnects()
{
    connect(actionAbout, SIGNAL(triggered()), this, SLOT(aboutQtGoogleTasks()));
}

void MainWindow::aboutQtGoogleTasks()
{
    QMessageBox::information(this, tr("About QtGoogleTasks"),
        tr("QtGoogleTasks - a simple Google Tasks client that loads the Google Tasks website<br>") +
        "v0.0.1<br>" +
        tr("For more information and other apps visit <a href=\"http://www.mobileqt.de/apps\">mobileqt.de</a>."));
}

void MainWindow::createLayout()
{
    layoutZentral = new QHBoxLayout();
    layoutZentral->addWidget(webviewGoogleTasks);
}

void MainWindow::selfAssignLayout()
{
    QWidget * widgetZentral = new QWidget();
    widgetZentral->setLayout(layoutZentral);
    this->setCentralWidget(widgetZentral);
}

void MainWindow::retranslateUi()
{
    setWindowTitle(tr("Google Tasks"));
    actionAbout->setText(QApplication::translate("MainWindow", "About QtGoogleTasks", 0, QApplication::UnicodeUTF8));
}

void MainWindow::closeEvent(QCloseEvent *event)
{
    QSettings settings("mobileqt.de", "QtGoogleTasks");
    settings.setValue("cookieJar", serializeCookies(cookiejarGoogleTasks->cookiesForUrl(QUrl("https://mail.google.com/tasks/ig"))));
    QMainWindow::closeEvent(event);
}

MainWindow::~MainWindow()
{
}

