// TODO
// 1. Settings selected in Settings window to take effect
// X 1.1 Course & chapter selection
// 1.2 Display language selection
// X 1.3 What to display (all/learned)
// X 1.4 Sort order (Random/alphabetic/Difficulty)
// 2 Make it run on mobile phone
// 2.1 On S60 FP1 emulator (Go to 3)
// 2.2 On S60 FP1 phone
// x 2.3 On Meemo emulator
// x 2.4 On Maemo
// 3 Adjust the UI to mobile phone
// 3.1 Adjust to S60
// x 3.1.1 Display current Course/Chapter in main window?
// x 3.2 Adjust to Maemo
// 4. Add highscores
// 5. Add Twitter/SMS
// 6. Add GPS
// 7. Add editing capabilities
// 8. Add other language (French? Swedish? Other?)
// x 9. Display learning % on the chapters
// 10. Add animations
// 11. Add download of databases from web
// 12. Add audio
// 13.

// BUGS
// 1 When 'Not Learned' is selected and there are no more 'not learned' to show, there is a 'not positioned on a valid record error as
//   the query does not return any value.
// X 2 The chapter score progress bar does not increase as more is learnt, but the colour changes.
// 3 When the word score hits 100 it seems that the session score does not get updated anymore.
// X 4 The colour of the chapter score progress bar is the same as the word score progress bar.
// 5 Crash if no Course is selected in Settings.

#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "settings.h"
#include "importflashcard.h"
#include <QDomDocument>
#include <QFile>
#include <QDir>
#include <Qt/qiodevice.h>
#include <QDomNode>
#include <QMessageBox>
#include <QDebug>
#include <QDomText>
#include <QSqlDatabase>
#include <QSqlQuery>
#include <QSqlError>
#include <QSqlRecord>
#include <QPlastiqueStyle>
#include <QtGui>
//#include <QtCore/qpropertyanimation.h>
//#include <QtPropertyAnimation>
//#include <QtEasingCurve>
//#include <Phonon>
//#include <Phonon/MediaObject>

QSqlRecord rec;
QSqlDatabase db;
int qiScore;
int qiScoreDelta;
int qiWordID=0;
int qiLessonID=1;
int qiSortBy=1;
int qiSelectBy=1;
QString qsLessonName;
QString sside1;
QString sside2;
QString sside3;
//bool bshowSide1;
//bool bshowSide2;
//bool bshowSide3;
int iChapterID;
int iCourseID;

QString sMandarin;
Settings *dlgSettings;
importflashcard *dlgImportFlashcards;

//QtPropertyAnimation animation;
//QtPropertyAnimation animation2;


MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    QSqlDatabase db = QSqlDatabase::addDatabase("QSQLITE");

    #ifdef Q_OS_LINUX
		// NOTE: We have to store database file into user home folder in Linux
		QString path(QDir::home().path());
		path.append(QDir::separator()).append("qteachme.db");
		path = QDir::toNativeSeparators(path);
                qDebug() << "Db path:" << path;
		db.setDatabaseName(path);
    #else
		// NOTE: File exists in the application private folder, in Symbian Qt implementation
                QString path("qteachme.db");
		db.setDatabaseName("qteachme.db");
    #endif

    QFile dbFile(path);
    dbFile.setPermissions(QFile::ReadOwner | QFile::WriteOwner | QFile::ReadUser |QFile::WriteUser);

    dlgSettings = new Settings;
    dlgImportFlashcards = new importflashcard;
//    db.setDatabaseName("qteachme.db");

    if ((!db.open()) || (db.tables().count() == 0))
    {
        qDebug() << "Failed to connect";
        qDebug() << db.lastError();
//        qFatal ("Failed to connect");
        //In case there is no database, we need to create a new one by importing some files.
        dlgImportFlashcards->createDatabase();
        dlgImportFlashcards->show();
        if (dlgImportFlashcards->exec() == QDialog::Accepted)
        {
        }
        SettingsMenu();

    }

    QSqlQuery qry;


// For the time being, always start with CourseID=1 and ChapterID=1

    qry.prepare("SELECT courseid, chapterid FROM settings");

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    qry.next();

    iCourseID = qry.value(0).toInt();
    qDebug() << "iCourseID" << iCourseID;
    iChapterID = qry.value(1).toInt();
    qDebug() << "iChapterID" << iChapterID;

//    iCourseID = 1;
//    iChapterID = 1;


    qry.prepare("SELECT name "
                "FROM chapters "
                "WHERE rowid=:chapterid");

    qry.bindValue(":chapterid", iChapterID);
    qDebug() << "iChapterID" << iChapterID;
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }
    qry.next();

    qsLessonName=qry.value(0).toString();
    qDebug() << "qsLessonName" << qsLessonName;

    qry.prepare("SELECT showside1, showside2, showside3, showside4, "
                "sortby, selectby "
                "FROM courses "
                "WHERE courseid=:courseid");

    qry.bindValue(":courseid", iCourseID);
    qDebug() << "iCourseID" << iCourseID;
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    qry.next();

    dlgSettings->setshowSide1(qry.value(0).toBool());
    qDebug() << dlgSettings->showSide1();
    dlgSettings->setshowSide2(qry.value(1).toBool());
    qDebug() << dlgSettings->showSide2();
    dlgSettings->setshowSide3(qry.value(2).toBool());
    qDebug() << dlgSettings->showSide3();

    connect(this, SIGNAL(side3Changed(QString)), ui->txtSide3, SLOT(setText(QString)));
    connect(this, SIGNAL(side2Changed(QString)), ui->txtSide2, SLOT(setText(QString)));
    connect(this, SIGNAL(side1Changed(QString)), ui->txtSide1, SLOT(setText(QString)));
    ui->txtSide2->viewport()->setAutoFillBackground(false);
    ui->txtSide3->viewport()->setAutoFillBackground(false);
    ui->txtSide1->viewport()->setAutoFillBackground(false);
	
    if (db.tables().count()>0)
    {
        this->handleSelection(0);
    }

//    ui->pbSettings->setVisible(false);
//    ui->pushButton_6->setVisible(false);
    ui->txtSide3->setAlignment(Qt::AlignCenter);
    ui->txtSide2->setAlignment(Qt::AlignCenter);
    ui->txtSide1->setAlignment(Qt::AlignCenter);
    ui->pbBad->setVisible(false);
    ui->pbGood->setVisible(false);
    ui->pbOK->setVisible(false);
    ui->pbShow->setVisible(true);
    ui->txtSide1->setVisible(dlgSettings->showSide1());
    qDebug() << dlgSettings->showSide1();
    ui->txtSide2->setVisible(dlgSettings->showSide2());
    qDebug() << dlgSettings->showSide2();
    ui->txtSide3->setVisible(dlgSettings->showSide3());
    qDebug() << dlgSettings->showSide3();

//    QPalette pal = widget.palette();
    QPalette pal = this->palette();
    pal.setColor(QPalette::Window, Qt::white);
    this->setPalette(pal);

    QMenuBar *menuBar=new QMenuBar();
    QAction *showSettings=new QAction("Settings",this);
    menuBar->addAction(showSettings);
    connect(showSettings,SIGNAL(triggered()),this, SLOT(SettingsMenu()));
    QAction *showImportFlashcards=new QAction("Import Flashcards",this);
    menuBar->addAction(showImportFlashcards);
    connect(showImportFlashcards,SIGNAL(triggered()),this,SLOT(showImportFlashcards()));
    QAction *showAbout=new QAction("About",this);
    menuBar->addAction(showAbout);
    connect(showAbout, SIGNAL(triggered()), this, SLOT(showAbout()));
    QAction *showPurge=new QAction("Purge All Flashcards",this);
    menuBar->addAction(showPurge);
    connect(showPurge,SIGNAL(triggered()),this, SLOT(purgeAll()));
    setMenuBar(menuBar);

    ui->progressBarWord->setStyle(new QPlastiqueStyle);
    ui->progressBarCourse->setStyle(new QPlastiqueStyle);
}

MainWindow::~MainWindow()
{
    delete ui;
}


/*
void MainWindow::on_pushButton_6_clicked()
{
    int iChapterID = 1;
    int iCourseID = 1;
    int iPreviousCourseID = 0;
    QDomDocument doc( "HSKML" );

    #ifdef Q_OS_LINUX
		QString xmlpath(QDir::home().path());
		xmlpath.append(QDir::separator()).append("hsk.xml");
		xmlpath = QDir::toNativeSeparators(xmlpath);
        qDebug() << "XML path:" << xmlpath;
		QFile file(xmlpath);
    #else
		QFile file( "./hsk.xml" );
    #endif

	file.open( QIODevice::ReadOnly );
//    if( !file.open( QIODevice::ReadOnly ) )
//        int ret = 1;
    if( !doc.setContent( &file ) )
    {
      file.close();
    }
    file.close();

    db = QSqlDatabase::addDatabase("QSQLITE");

    #ifdef Q_OS_LINUX
		// NOTE: We have to store database file into user home folder in Linux
		QString path(QDir::home().path());
		path.append(QDir::separator()).append("qteachme.db");
		path = QDir::toNativeSeparators(path);
        qDebug() << "Db path:" << path;
		db.setDatabaseName(path);
    #else
		// NOTE: File exists in the application private folder, in Symbian Qt implementation
		db.setDatabaseName("qteachme.db");
    #endif
	
    if (!db.open())
    {
        qDebug() << "Failed to connect";
        qDebug() << db.lastError();
    }

    QSqlQuery qry;
    QSqlQuery qry2;
    int i;

    i=0;

    if (!qry.exec("CREATE TABLE IF NOT EXISTS words "
                  "(side3 VARCHAR(80), side2 VARCHAR(40), side1 VARCHAR(10), "
                  "traditional VARCHAR(10), part_of_speech VARCHAR(20))"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (!qry.exec("DELETE FROM words"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (!qry.exec("CREATE TABLE IF NOT EXISTS courses "
                  "(name VARCHAR(40),"
                  "lang1 VARCHAR(20), lang2 VARCHAR(20), lang3 VARCHAR(20), lang4 VARCHAR(20), "
                  "showSide1 SMALLINT, showSide2 SMALLINT, showSide3 SMALLINT, showSide4 SMALLINT, "
                  "sortby SMALLINT, selectby SMALLINT)"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (!qry.exec("DELETE FROM courses"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (!qry.exec("CREATE TABLE IF NOT EXISTS chapters (name VARCHAR(40), "
                  "courseid INT)"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (!qry.exec("DELETE FROM chapters"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }


    qry.prepare("INSERT INTO courses (name, ROWID) VALUES ('HSK Level 1', 1)");
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    qry.prepare("INSERT INTO courses (name, ROWID) VALUES ('HSK Level 2', 2)");
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    qry.prepare("INSERT INTO courses (name, ROWID) VALUES ('HSK Level 3', 3)");
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    qry.prepare("INSERT INTO courses (name, ROWID) VALUES ('HSK Level 4', 4)");
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (!qry.exec("CREATE TABLE IF NOT EXISTS chapterwords (wordid SMALLINT, lessonid SMALLINT, score SMALLINT, scoredelta SMALLINT)"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (!qry.exec("DELETE FROM chapterwords"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    qry.prepare("BEGIN");
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    ui->txtSide1->setAlignment(Qt::AlignCenter);

    QDomElement root = doc.documentElement();
    if (root.tagName()=="words")
    {
        QDomNode nodeWord = root.firstChild();
//        while (i<2000)
          while (!nodeWord.isNull())
        {
            if(nodeWord.isElement())
            {
                qry.prepare("INSERT INTO words (side3, side2, side1, traditional, part_of_speech) VALUES "
                            "(:side3, :side2, :side1, :traditional, :part_of_speech)");
                qry2.prepare("INSERT INTO chapterwords (lessonid, wordid, score, scoredelta) VALUES "
                            "(:lessonid, :wordid, :score, :scoredelta)");
                QDomElement element = nodeWord.toElement();
                QDomNode nodeside3 = nodeWord.firstChildElement("en");
                if(nodeside3.isElement())
                {
                    QDomElement element = nodeside3.toElement();
                    if (element.text().length()>80)
                    {
                        qDebug() << "side3:" <<element.text();
                        qDebug() << "LENGTH:" <<element.text().length();
                    }
                    qry.bindValue(":side3", element.text());
//                    ui->txtSide3->setText(element.text());
                }
                QDomNode nodeside2 = nodeWord.firstChildElement("side2");
                if(nodeside2.isElement())
                {
                    QDomElement element = nodeside2.toElement();
                    if (element.text().length()>40)
                    {
                        qDebug() << "side2:" <<element.text();
                        qDebug() << "LENGTH:" <<element.text().length();
                    }
                    qry.bindValue(":side2", element.text());
//                    ui->txtSide2->setText(element.text());
                }
                QDomNode nodeside1 = nodeWord.firstChildElement("side1");
                if(nodeside1.isElement())
                {
                    QDomElement element = nodeside1.toElement();
                    if (element.text().length()>10)
                    {
                        qDebug() << "side1:" <<element.text();
                        qDebug() << "LENGTH:" <<element.text().length();
                    }
                    qry.bindValue(":side1", element.text());
//                    ui->txtSide1->setText(element.text());
                }

                QDomNode nodeTraditional = nodeWord.firstChildElement("traditional");
                if(nodeTraditional.isElement())
                {
                    QDomElement element = nodeTraditional.toElement();
                    if (element.text().length()>10)
                    {
                        qDebug() << "TRADITIONAL:" <<element.text();
                        qDebug() << "LENGTH:" <<element.text().length();
                    }
//                    qry.bindValue(":traditional", element.text());
                }

                QDomNode nodePartOfSpeech = nodeWord.firstChildElement("part_of_speech");
                if(nodePartOfSpeech.isElement())
                {
                    QDomElement element = nodePartOfSpeech.toElement();
                    qry.bindValue(":part_of_speech", element.text());
                }



                QDomNode nodeLevel = nodeWord.firstChildElement("level");
                if(nodeLevel.isElement())
                {
                    QDomElement element = nodeLevel.toElement();
//                    qry2.bindValue(":lessonid", element.text().toShort());
                    iCourseID=element.text().toInt();
// Hardcoded for the time being.
                    iCourseID = 1;
                    qDebug() << "Level  : " << element.text().toInt();
                    qDebug() << "Course : " << iCourseID;
                    qDebug() << "Chapter: " << iChapterID;

                    if (element.text().toInt()!=iCourseID)
                    {
                        iChapterID++;
                    }

                }

                qry2.bindValue(":lessonid", iChapterID);

            }
            qApp->processEvents();
            if (!qry.exec())
            {
                qDebug() << qry.lastQuery();
                qDebug() << qry.lastError();
                qDebug() << qry.executedQuery();
                qDebug() << qry.boundValues();
            }

            qry2.bindValue(":wordid", qry.lastInsertId());
            qry2.bindValue(":score", 20);
            qry2.bindValue(":scoredelta", 0);
            if (!qry2.exec())
            {
                qDebug() << qry2.lastQuery();
                qDebug() << qry2.lastError();
            }

            if(nodeWord.isText())
            {
                QDomText text = nodeWord.toText();
                qDebug() << text.data();
            }
            nodeWord =nodeWord.nextSibling();
            i++;

            if ((i%20)==0)
            {
                qry2.prepare("INSERT INTO chapters (name, courseid) VALUES "
                            "(:chaptername, :courseid)");
                qry2.bindValue(":chaptername", "Chapter " + QString::number(iChapterID,10));
                qry2.bindValue(":courseid", iCourseID);
                if (!qry2.exec())
                {
                    qDebug() << qry2.lastQuery();
                    qDebug() << qry2.lastError();
                }
                qDebug() << "Chapter " << iChapterID;
                iChapterID++;
            }

//            qry.prepare("INSERT INTO courses (name, ROWID) VALUES ('HSK Level 1', 1)");
            if (iCourseID != iPreviousCourseID)
            {
                qry.prepare("INSERT INTO courses (name, ROWID) VALUES (:coursename, :courseid)");
                qry.bindValue(":coursename", "Course " + QString::number(iCourseID,10));
                qry.bindValue(":courseid", iCourseID);
                if (!qry.exec())
                {
                    qDebug() << qry.lastQuery();
                    qDebug() << qry.lastError();
                }
                iPreviousCourseID = iCourseID;
            }


        }
    }

    qry.prepare("COMMIT");
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    qry.prepare("SELECT COUNT(*) AS wordcount FROM words");
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    while (qry.next()) {
        QString wordcount = qry.value(0).toString();
        qDebug() << wordcount;
     }

    qry.prepare("SELECT COUNT(*) AS wordcount FROM chapterwords");
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    while (qry.next()) {
        QString wordcount = qry.value(0).toString();
        qDebug() << wordcount;
     }
//    QMessageBox msgBox;
//    msgBox.setText(sText.data());
//    msgBox.setInformativeText("Do you want to save your changes?");
//    msgBox.setStandardButtons(QMessageBox::Cancel);
//    msgBox.setDefaultButton(QMessageBox::Cancel);
//    int ret = msgBox.exec();

}
*/

/*
void MainWindow::SettingsMenu()
{
    qDebug() << "Settings Menu";
}
*/

void MainWindow::setSide3(const QString &text)
{
    if (sside3 == text)
        return;

    sside3 = text;
    emit side3Changed(sside3);
}

void MainWindow::setSide1(const QString &text)
{
    if (sside1 == text)
        return;

    sside1 = text;
    emit side1Changed(sside1);
}

void MainWindow::setSide2(const QString &text)
{
    if (sside2 == text)
        return;

    sside2 = text;
    emit side2Changed(sside2);
}


void MainWindow::setMandarin(const QString &text)
{
    if (sMandarin == text)
        return;

    sMandarin = text;
    emit mandarinChanged(sMandarin);
}


void MainWindow::handleSelection(const int iChangeScore)
{

    QSqlQuery qry;
    QSqlQuery qry2;
    QString sortOrder;
    QString selectBy;
//	QtPropertyAnimation animation;
	 
    if (qiWordID>0)
    {

        #ifdef Q_OS_LINUX
                // NOTE: We have to store database file into user home folder in Linux
                QString path(QDir::home().path());
                path.append(QDir::separator()).append("audio").append(QDir::separator()).append("test.aac");
                path = QDir::toNativeSeparators(path);
                qDebug() << "Audio path:" << path;
        #else
                // NOTE: File exists in the application private folder, in Symbian Qt implementation
                QString path( "./audio/test.aac" );
        #endif

        QFile audiofile(path);

        if (audiofile.exists())
        {

//		mediaObject = new Phonon::MediaObject();
//		Phonon::MediaObject *mediaObject =
//				 Phonon::createPlayer(Phonon::MusicCategory,
//									  Phonon::MediaSource(path));
//			 mediaObject->play();
        }

         if (iChangeScore<0)
        {
            if (qiScoreDelta<=0)
            {
                qiScoreDelta=qiScoreDelta+iChangeScore;
            }
            else             {
                qiScoreDelta=iChangeScore;
            }

        }
        else if (iChangeScore>0)
        {
            if (qiScoreDelta>=0)
            {
                qiScoreDelta=qiScoreDelta+iChangeScore;
            }
            else             {
                qiScoreDelta=iChangeScore;
            }
        }
        else
        {
            qiScoreDelta=0;
        }

        qiScore=qiScore+qiScoreDelta;

        if (qiScore<0)
        {
            qiScore=0;
            qiScoreDelta=0;
        }
        else if (qiScore>100)
        {
            qiScore=100;
            qiScoreDelta=0;
        }

        QPalette pal = ui->lblScore->palette();

        QString strScore;
        strScore = QString::number(ui->lblScore->text().toInt() + qiScoreDelta,10);
        ui->lblScore->setText(strScore);
        if (strScore.toInt()>0)
        {
            pal.setColor(QPalette::WindowText, Qt::blue);
        }
        else
        {
            pal.setColor(QPalette::WindowText, Qt::red);
        }
        ui->lblScore->setPalette(pal);
        ui->lblScore->setAlignment(Qt::AlignRight);

//      THIS SHOULD ALSO INCLUDE LESSONID!
        qry.prepare("UPDATE chapterwords SET score=:score, scoredelta=:scoredelta WHERE wordid=:wordid ");

        qry.bindValue(":score", qiScore);
        qry.bindValue(":scoredelta", qiScoreDelta);
        qry.bindValue(":wordid", qiWordID);

        qDebug() << "side3=" << sside3;
        qDebug() << "qiScore=" << qiScore;
        qDebug() << "qiScoreDelta=" << qiScoreDelta;
        qDebug() << "qiWordID=" << qiWordID;

        if (!qry.exec())
        {
            qDebug() << qry.lastQuery();
            qDebug() << qry.lastError();
        }
    }
    // Select word in random order
    // , RANDOM() LIMIT 1
    // WHERE wordid <> :wordid has been added to avoid the same
    // word being asked for consecutively.

	
	//For the time being the sort order is hardcoded until the
	//Settings window isn't fixed.
//	qiSortBy = 3;
	
    if (qiSelectBy == 1) //All
    {
        selectBy = "";
    }
    else if (qiSelectBy == 2) //Not learned
    {
        selectBy = " AND score <100 ";
    }

    if (qiSortBy == 1) //Random
    {
        sortOrder = " ORDER BY RANDOM() LIMIT 1 ";
    }
    else if (qiSortBy == 2) //Alphabetic
    {
        sortOrder = "";
    }
    else if (qiSortBy == 3) //Difficulty
    {
        sortOrder = " ORDER BY score ASC, RANDOM() LIMIT 1 ";
    }

    qry2.prepare("SELECT lessonid, wordid, score, scoredelta "
                 "FROM chapterwords "
                 "WHERE wordid <> :wordid "
                 "AND lessonid = :lessonid "
                 + selectBy
                 + sortOrder);
    qry2.bindValue(":wordid", qiWordID);
    qry2.bindValue(":lessonid", qiLessonID);
    if (!qry2.exec())
    {
        qDebug() << qry2.lastQuery();
        qDebug() << qry2.size();
        qDebug() << qry2.lastError();

    }
    qDebug() << qry2.lastQuery();
    qry2.next();
    qiScore=qry2.value(2).toInt();

    qDebug() << qiScore;
    qiScoreDelta=qry2.value(3).toInt();
    qDebug() << qiScoreDelta;
    rec = qry2.record();

    if (!qry.prepare("SELECT side1, side2, side3 "
                     "FROM words "
                     "WHERE rowid=:wordid"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    qiWordID=qry2.value(1).toInt();
    qDebug() << "qiWordID=" << qiWordID;
    qry.bindValue(":wordid", qry2.value(1).toInt());

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }
    qry.next();

/*
        QtPropertyAnimation animation(ui->txtSide3, "y");

         QtPropertyAnimation *animation = new QtPropertyAnimation(ui->txtSide3, "y");

	 animation.setDuration(500);
	 animation.setStartValue(0);
         animation.setEndValue(ui->txtSide3->y);
	 animation.setEasingCurve (QtEasingCurve::OutBack);
	 animation.start();
         QtPropertyAnimation animation2(ui->txtSide2, "y");
	 animation2.setDuration(500);
	 animation2.setStartValue(0);
         animation2.setEndValue(ui->txtSide2->y);
	 animation2.setEasingCurve (QtEasingCurve::OutBack);
	 animation2.start();
*/
	 
// EMIT TO SLOT?
    this->setSide1(qry.value(0).toString());
    this->setSide2(qry.value(1).toString());
    this->setSide3(qry.value(2).toString());
    qDebug() << "side1:" << qry.value(2).toString();
//    this->setMandarin(qry.value(0).toString());
//    ui->txtSide1->setText(qry.value(2).toString());
//    ui->txtSide1->setAlignment(Qt::AlignCenter);
    ui->txtSide3->setAlignment(Qt::AlignCenter);
    ui->txtSide2->setAlignment(Qt::AlignCenter);
    ui->txtSide1->setAlignment(Qt::AlignCenter);
    ui->pbBad->setVisible(false);
    ui->pbGood->setVisible(false);
    ui->pbOK->setVisible(false);
    ui->pbShow->setVisible(true);
    ui->txtSide1->setVisible(dlgSettings->showSide1());//dlgSettings->showSide1());
    qDebug() << dlgSettings->showSide1();
    ui->txtSide2->setVisible(dlgSettings->showSide2());//dlgSettings->showSide2());
    qDebug() << dlgSettings->showSide2();
    ui->txtSide3->setVisible(dlgSettings->showSide3());//dlgSettings->showSide3());
    qDebug() << dlgSettings->showSide3();
    ui->progressBarWord->setValue(qiScore);

    QPalette pal = ui->progressBarWord->palette();
    if (qiScore<20)
    {
        pal.setColor(QPalette::Highlight, Qt::red);
    }
    else if (qiScore>=20 &&qiScore<=80)
    {
        pal.setColor(QPalette::Highlight, Qt::darkYellow);
    }
    else if (qiScore>80)
    {
        pal.setColor(QPalette::Highlight, Qt::green);
    }
    ui->progressBarWord->setPalette(pal);

    //Get chapter progress
    //THIS SHOULD ALSO INCLUDE LESSONID!
//    qry.prepare("SELECT COUNT(*) AS learnt FROM chapterwords WHERE score>=30");
// Would it be possible to combine into one SELECT statement, SUM(score)/COUNT(*)?
    qry.prepare("SELECT SUM(score) AS learnt FROM chapterwords WHERE lessonid=:lessonid");
    qry.bindValue(":lessonid", qiLessonID);
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }
    qry.next();
    int iLearnt = qry.value(0).toInt();
    qDebug() << iLearnt ;

    qry2.prepare("SELECT COUNT(*) AS chaptercount FROM chapterwords WHERE lessonid=:lessonid");
    qry2.bindValue(":lessonid", qiLessonID);
    if (!qry2.exec())
    {
        qDebug() << qry2.lastQuery();
        qDebug() << qry2.lastError();
    }
    qry2.next();

    int iCount = qry2.value(0).toInt();
    if (iCount != 0 )
    {
        qiScore = iLearnt/iCount;
    }
    else
    {
        qiScore = 20;
    }
    qDebug() << "iCount  = " << iCount;
    qDebug() << "qiScore = " << qiScore;
    ui->progressBarCourse->setValue((qiScore));
    ui->progressBarCourse->setFormat(qsLessonName + ": %p%");

    pal = ui->progressBarCourse->palette();
    if (qiScore<20)
    {
        pal.setColor(QPalette::Highlight, Qt::red);
    }
    else if (qiScore>=20 &&qiScore<=80)
    {
        pal.setColor(QPalette::Highlight, Qt::darkYellow);
    }
    else if (qiScore>80)
    {
        pal.setColor(QPalette::Highlight, Qt::green);
    }
    ui->progressBarCourse->setPalette(pal);

    qApp->processEvents();
}

void MainWindow::purgeAll()
{
    dlgImportFlashcards->purgeDatabase();
}


//void MainWindow::on_pbSettings_clicked()
void MainWindow::SettingsMenu()
{

//    int iCourseID;

    QSqlQuery qry;
    QString courseName;
    QString chapterName;

    //Launch the Settings Window
    dlgSettings->show();

    qry.prepare("SELECT rowid, name "
                 "FROM courses");

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.size();
        qDebug() << qry.lastError();

    }
    qry.next();

    dlgSettings->lstCourse->clear();
    while (qry.isValid())
    {
        dlgSettings->lstCourse->addItem(qry.value(1).toString());
        if (iCourseID == qry.value(0).toInt())
        {
            courseName=qry.value(1).toString();
        }
        qry.next();
    }

    //This should trigger the selection of chapters.
    dlgSettings->lstCourse->setCurrentIndex(dlgSettings->lstCourse->findText(courseName));

    qApp->processEvents();

    chapterName = courseName + ": Chapter " + QString::number(qiLessonID,10);
    qDebug() << "chapterName" << chapterName;
    int index;
    index = dlgSettings->listChapter->findText(chapterName);
    qDebug() << "index" << index;
    dlgSettings->listChapter->setCurrentIndex(index);

/*
    qry.prepare("SELECT * "
                "FROM chapters "
                "WHERE courseid=:courseid");

    qDebug() << iCourseID;
    qry.bindValue(":courseid", iCourseID);
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.size();
        qDebug() << qry.lastError();
    }

    qDebug() << qry.numRowsAffected();
    qry.next();
    dlgSettings->listChapter->clear();
    while (qry.isValid())
    {
        qDebug() << qry.value(0);
        qDebug() << qry.value(1);
        qDebug() << qry.value(2);
        qDebug() << qry.value(3);
        dlgSettings->listChapter->addItem(qry.value(0).toString());
        qry.next();
    }
*/

    if (dlgSettings->exec() == QDialog::Accepted)
    {
        QSqlQuery qry;

        qry.prepare("UPDATE courses SET "
                    "showside1=:showSide1, showside2=:showSide2, showside3=:showSide3, showside4=:showSide4, "
                    "sortby=:sortBy, selectby=:selectBy "
                    "WHERE courseid=:courseid");

        qry.bindValue(":showSide1", dlgSettings->showSide1());
//        qDebug << "dlgSettings->showSide1()" << dlgSettings->showSide1();
        qry.bindValue(":showSide2", dlgSettings->showSide2());
//        qDebug << "dlgSettings->showSide2()" << dlgSettings->showSide2();
        qry.bindValue(":showSide3", dlgSettings->showSide3());
//        qDebug << "dlgSettings->showSide3()" << dlgSettings->showSide3();
        qry.bindValue(":showSide4", dlgSettings->showSide4());
 //       qDebug << "dlgSettings->showSide4()" << dlgSettings->showSide4();
        qiSortBy = dlgSettings->sortBy();
        qry.bindValue(":sortBy", qiSortBy);
        qDebug() << "SortBy: " << qiSortBy;
        qiSelectBy = dlgSettings->selectBy();
        qry.bindValue(":selectBy", qiSelectBy);
        qDebug() << "SelectBy: " << qiSelectBy;
//        qDebug() << "listChapter.selected.text : " << dlgSettings->listChapter->currentText();
//        qDebug() << "lstCourse.selected.text " << dlgSettings->lstCourse->currentText();
//  HARDCODED
        qDebug() << "dlgSettings->courseID()" << dlgSettings->courseID();
        qry.bindValue(":courseid", dlgSettings->courseID());

        QMapIterator<QString, QVariant> i(qry.boundValues());
        while (i.hasNext()) {
            i.next();
            qDebug() << i.key().toAscii().data() << ": "
                 << i.value().toString().toAscii().data() << endl;
        }

        if (!qry.exec())
        {
            qDebug() << qry.lastQuery();
            qDebug() << qry.lastError();
        }

        qsLessonName=dlgSettings->listChapter->currentText();

        /*
        qry.prepare("SELECT rowid "
                    "FROM chapters "
                    "WHERE name=:name");

        qsLessonName=dlgSettings->listChapter->currentText();
        qry.bindValue(":name", qsLessonName);
        if (!qry.exec())
        {
            qDebug() << qry.lastQuery();
            qDebug() << qry.size();
            qDebug() << qry.lastError();
        }
        qry.next();
        qDebug() << "LessonID : " << qry.value(0);
        qDebug() << "Name : " << dlgSettings->listChapter->currentText();
        qiLessonID=qry.value(0).toInt();
 */
        qiLessonID=dlgSettings->chapterID();

        this->handleSelection(0);
    }
}

void MainWindow::on_pbOK_clicked()
{
    this->handleSelection(0);
}

void MainWindow::on_pbBad_clicked()
{
    this->handleSelection(-3);
}
void MainWindow::on_pbGood_clicked()
{
    this->handleSelection(5);
}

void MainWindow::on_pbShow_clicked()
{
    ui->pbShow->setVisible(false);
    ui->pbBad->setVisible(true);
    ui->pbGood->setVisible(true);
    ui->pbOK->setVisible(true);
    ui->txtSide1->setVisible(true);
    ui->txtSide2->setVisible(true);
    ui->txtSide3->setVisible(true);
}

void MainWindow::showAbout()
{
    QString message = "";
    QString version;

//    message.append(APP_NAME);
    message.append("Qteachme");
    message.append("-");
//    version = version.setNum(APP_VERSION);
    version = "0.1.1";
    message.append(version);
    message.append("\n by ");
//    message.append(AUTHOR);
    message.append("Magnus Lundgren (magnuslu@hotmail.com)");
    QMessageBox::about ( this, tr("About"), message);
}

void MainWindow::showImportFlashcards()
{
    dlgImportFlashcards->show();
    if (dlgImportFlashcards->exec() == QDialog::Accepted)
    {
    }
}
