#include "importflashcard.h"
#include "ui_importflashcard.h"
#include <QFileDialog>
#include <QDomDocument>
#include <QDomNode>
#include <QFile>
#include <QDebug>
#include <QDomText>
#include <QSqlDatabase>
#include <QSqlQuery>
#include <QSqlError>
#include <QSqlRecord>

//QSqlRecord rec;
//QSqlDatabase db;

importflashcard::importflashcard(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::importflashcard)
{
    ui->setupUi(this);
}

importflashcard::~importflashcard()
{
    delete ui;
}

void importflashcard::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void importflashcard::on_pushBrowse_clicked()
{

    QString fileName;

    QString homepath(QDir::home().path());

    fileName = QFileDialog::getOpenFileName(this,
         tr("Open Flashcard Set"), homepath, tr("Flashcard Files (*.txt)"));

    ui->plainFileName->setPlainText(fileName);
}

void importflashcard::on_pushImport_clicked()
{
    int iChapterID = 1;
    int iCourseID = 1;
    int iPreviousCourseID = 0;
    QSqlDatabase db;
    QDomDocument doc( "HSKML" );

    #ifdef Q_OS_LINUX
//                QString xmlpath(QDir::home().path());
//                xmlpath.append(QDir::separator()).append("hsk.xml");
//                xmlpath = QDir::toNativeSeparators(xmlpath);
//        qDebug() << "XML path:" << xmlpath;
//                QFile file(xmlpath);
    #else
//                QFile file( "./hsk.xml" );
    #endif
    QFile file(ui->plainFileName);

    ui->lblImporting->setText("Importing...");

//    createDatabase();
//    purgeDatabase();
    qApp->processEvents();
    this->importdelimited(ui->plainFileName->toPlainText());
    ui->lblImporting->setText("");

    return;

    file.open( QIODevice::ReadOnly );
//    if( !file.open( QIODevice::ReadOnly ) )
//        int ret = 1;
    if( !doc.setContent( &file ) )
    {
      file.close();
    }
    file.close();

    db = QSqlDatabase::addDatabase("QSQLITE");

    #ifdef Q_OS_LINUX
                // NOTE: We have to store database file into user home folder in Linux
                QString path(QDir::home().path());
                path.append(QDir::separator()).append("qteachme.db");
                path = QDir::toNativeSeparators(path);
        qDebug() << "Db path:" << path;
                db.setDatabaseName(path);
    #else
                // NOTE: File exists in the application private folder, in Symbian Qt implementation
                db.setDatabaseName("qteachme.db");
    #endif

    if (!db.open())
    {
        qDebug() << "Failed to connect";
        qDebug() << db.lastError();
        createDatabase();
        purgeDatabase();
    }

    QSqlQuery qry;
    QSqlQuery qry2;
    int i;

    i=0;


/*
    if (!qry.exec("CREATE TABLE IF NOT EXISTS words "
                  "(english VARCHAR(80), pinyin VARCHAR(40), simplified VARCHAR(10), "
                  "traditional VARCHAR(10), part_of_speech VARCHAR(20))"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (!qry.exec("DELETE FROM words"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (!qry.exec("CREATE TABLE IF NOT EXISTS courses "
                  "(name VARCHAR(40),"
                  "lang1 VARCHAR(20), lang2 VARCHAR(20), lang3 VARCHAR(20), lang4 VARCHAR(20), "
                  "showlang1 SMALLINT, showlang2 SMALLINT, showlang3 SMALLINT, showlang4 SMALLINT, "
                  "sortby SMALLINT, selectby SMALLINT)"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (!qry.exec("DELETE FROM courses"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (!qry.exec("CREATE TABLE IF NOT EXISTS chapters (name VARCHAR(40), "
                  "courseid INT)"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (!qry.exec("DELETE FROM chapters"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (!qry.exec("CREATE TABLE IF NOT EXISTS chapterwords (wordid SMALLINT, lessonid SMALLINT, score SMALLINT, scoredelta SMALLINT)"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (!qry.exec("DELETE FROM chapterwords"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }
*/

    qry.prepare("BEGIN");
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    QDomElement root = doc.documentElement();
    if (root.tagName()=="words")
    {
        QDomNode nodeWord = root.firstChild();
          while (!nodeWord.isNull())
        {
            if(nodeWord.isElement())
            {
                qry.prepare("INSERT INTO words (english, pinyin, simplified, traditional, part_of_speech) VALUES "
                            "(:english, :pinyin, :simplified, :traditional, :part_of_speech)");
                qry2.prepare("INSERT INTO chapterwords (lessonid, wordid, score, scoredelta) VALUES "
                            "(:lessonid, :wordid, :score, :scoredelta)");
                QDomElement element = nodeWord.toElement();
                QDomNode nodeEnglish = nodeWord.firstChildElement("en");
                if(nodeEnglish.isElement())
                {
                    QDomElement element = nodeEnglish.toElement();
                    if (element.text().length()>80)
                    {
                        qDebug() << "ENGLISH:" <<element.text();
                        qDebug() << "LENGTH:" <<element.text().length();
                    }
                    qry.bindValue(":english", element.text());
                }
                QDomNode nodePinyin = nodeWord.firstChildElement("pinyin");
                if(nodePinyin.isElement())
                {
                    QDomElement element = nodePinyin.toElement();
                    if (element.text().length()>40)
                    {
                        qDebug() << "PINYIN:" <<element.text();
                        qDebug() << "LENGTH:" <<element.text().length();
                    }
                    qry.bindValue(":pinyin", element.text());
                }
                QDomNode nodeSimplified = nodeWord.firstChildElement("simplified");
                if(nodeSimplified.isElement())
                {
                    QDomElement element = nodeSimplified.toElement();
                    if (element.text().length()>10)
                    {
                        qDebug() << "SIMPLIFIED:" <<element.text();
                        qDebug() << "LENGTH:" <<element.text().length();
                    }
                    qry.bindValue(":simplified", element.text());
                }

                QDomNode nodeTraditional = nodeWord.firstChildElement("traditional");
                if(nodeTraditional.isElement())
                {
                    QDomElement element = nodeTraditional.toElement();
                    if (element.text().length()>10)
                    {
                        qDebug() << "TRADITIONAL:" <<element.text();
                        qDebug() << "LENGTH:" <<element.text().length();
                    }
                }


                QDomNode nodeLevel = nodeWord.firstChildElement("level");
                if(nodeLevel.isElement())
                {
                    QDomElement element = nodeLevel.toElement();
//                    qry2.bindValue(":lessonid", element.text().toShort());
                    iCourseID=element.text().toInt();
// Hardcoded for the time being.
                    iCourseID = 1;
                    qDebug() << "Level  : " << element.text().toInt();
                    qDebug() << "Course : " << iCourseID;
                    qDebug() << "Chapter: " << iChapterID;
/*
                    if (element.text().toInt()!=iCourseID)
                    {
                        iChapterID++;
                    }
*/
                }

                qry2.bindValue(":lessonid", iChapterID);

            }
            qApp->processEvents();
            if (!qry.exec())
            {
                qDebug() << qry.lastQuery();
                qDebug() << qry.lastError();
                qDebug() << qry.executedQuery();
                qDebug() << qry.boundValues();
            }

            qry2.bindValue(":wordid", qry.lastInsertId());
            qry2.bindValue(":score", 20);
            qry2.bindValue(":scoredelta", 0);
            if (!qry2.exec())
            {
                qDebug() << qry2.lastQuery();
                qDebug() << qry2.lastError();
            }

            if(nodeWord.isText())
            {
                QDomText text = nodeWord.toText();
                qDebug() << text.data();
            }
            nodeWord =nodeWord.nextSibling();
            i++;

            if ((i%20)==0)
            {
                qry2.prepare("INSERT INTO chapters (name, courseid) VALUES "
                            "(:chaptername, :courseid)");
                qry2.bindValue(":chaptername", "Chapter " + QString::number(iChapterID,10));
                qry2.bindValue(":courseid", iCourseID);
                if (!qry2.exec())
                {
                    qDebug() << qry2.lastQuery();
                    qDebug() << qry2.lastError();
                }
                qDebug() << "Chapter " << iChapterID;
                iChapterID++;
            }

//            qry.prepare("INSERT INTO courses (name, ROWID) VALUES ('HSK Level 1', 1)");
            if (iCourseID != iPreviousCourseID)
            {
                qry.prepare("INSERT INTO courses (name, ROWID) VALUES (:coursename, :courseid)");
                qry.bindValue(":coursename", "Course " + QString::number(iCourseID,10));
                qry.bindValue(":courseid", iCourseID);
                if (!qry.exec())
                {
                    qDebug() << qry.lastQuery();
                    qDebug() << qry.lastError();
                }
                iPreviousCourseID = iCourseID;
            }


        }
    }

    qry.prepare("COMMIT");
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    qry.prepare("SELECT COUNT(*) AS wordcount FROM words");
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    while (qry.next()) {
        QString wordcount = qry.value(0).toString();
        qDebug() << wordcount;
     }

    qry.prepare("SELECT COUNT(*) AS wordcount FROM chapterwords");
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    while (qry.next()) {
        QString wordcount = qry.value(0).toString();
        qDebug() << wordcount;
     }
//    QMessageBox msgBox;
//    msgBox.setText(sText.data());
//    msgBox.setInformativeText("Do you want to save your changes?");
//    msgBox.setStandardButtons(QMessageBox::Cancel);
//    msgBox.setDefaultButton(QMessageBox::Cancel);
//    int ret = msgBox.exec();

}

void importflashcard::importdelimited(QString filename)
{
    QFile filedelimited(filename);
    int i;
    int iWordCount = 0;
    int iCourseID;
    int iChapterID;
    int iChapterCount = 0;
    bool isFirstLine=true;
    QString strDelimiter;
    QSqlQuery qry;


    filedelimited.open( QIODevice::ReadOnly );

    QTextStream filestream(&filedelimited);
    filestream.setCodec("UTF-8");

    qry.prepare("BEGIN");
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    QString line;
    while (!filestream.atEnd()) {
        line = filestream.readLine();
        line.truncate(line.length());

        if (isFirstLine)
        {
            qDebug() << line;
            //Identify the used delimiter
            if (line.indexOf("|")!= -1)
            {
                strDelimiter = "|";
            }
            else if (line.indexOf("\t")!= -1)
            {
                strDelimiter = "\t";
            }
            else if (line.indexOf(",")!= -1)
            {
                strDelimiter = ",";
            }
            else if (line.indexOf(";")!= -1)
            {
                strDelimiter = ";";
            }
            else if (strDelimiter=="")
            {
                qDebug() << "Unknown Delimiter";
                return;
            }
            isFirstLine = false;

            iCourseID = createCourse(ui->plainCourseName->toPlainText(),
                                     ui->plainSide1->toPlainText(),
                                     ui->plainSide2->toPlainText(),
                                     ui->plainSide3->toPlainText(),
                                     "");

        }

        if (iWordCount%ui->plainCardsperChapter->toPlainText().toInt()==0)
        {
            iChapterCount++;
            iChapterID = createChapter(ui->plainCourseName->toPlainText(), iCourseID, iChapterCount);
        }

        iWordCount++;

        QStringList list1 = line.split(strDelimiter);

        for (i=0; i<list1.count(); i++)
        {
            qDebug() << list1[i];
        }
        createWord(iChapterID, list1);
    }


    filedelimited.close();

    qry.prepare("COMMIT");
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    filedelimited.setPermissions(QFile::ReadOwner | QFile::WriteOwner | QFile::ReadUser |QFile::WriteUser);

}

int importflashcard::createCourse(QString coursename,
                                  QString sSide1,
                                  QString sSide2,
                                  QString sSide3,
                                  QString sSide4)
{
    QSqlQuery qry;
    QSqlQuery qry2;
    int iCourseID;


    qry.prepare("SELECT MAX(courseid) FROM courses");
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }
    while (qry.next()) {
        iCourseID = qry.value(0).toInt();
        qDebug() << iCourseID ;
     }
    iCourseID++;

/*
    if (!qry.exec("CREATE TABLE IF NOT EXISTS courses "
                  "(name VARCHAR(40), courseid SMALLINT,"
                  "side1 VARCHAR(20), side2 VARCHAR(20), side3 VARCHAR(20), side4 VARCHAR(20), "
                  "showside1 SMALLINT, showside2 SMALLINT, showside3 SMALLINT, showside4 SMALLINT, "
                  "sortby SMALLINT, selectby SMALLINT)"))
*/

//    qry.prepare("INSERT INTO courses (name, ROWID, side1, side2, side3, side4) VALUES"
//                "(:coursename, :courseid, :side1, :side2, :side3, :side4)");
    qry2.prepare("INSERT INTO courses (name, courseid, side1, side2, side3, side4, showside1) VALUES "
                 "(:coursename, :courseid, :side1, :side2, :side3, :side4, :showside1)");
    qry2.bindValue(":coursename", coursename);
    qry2.bindValue(":courseid", iCourseID);
    qry2.bindValue(":side1", sSide1);
    qry2.bindValue(":side2", sSide2);
    qry2.bindValue(":side3", sSide3);
    qry2.bindValue(":side4", sSide4);
    qry2.bindValue(":showside1", 1);
    if (!qry2.exec())
    {
        qDebug() << qry2.lastQuery();
        qDebug() << qry2.lastError();
    }
    return iCourseID;

}

int importflashcard::createChapter(QString sCourseName, int iCourseID, int iChapterCount)
{
    QSqlQuery qry;

    qry.prepare("INSERT INTO chapters (name, courseid) VALUES "
                "(:chaptername, :courseid)");
    qry.bindValue(":chaptername", sCourseName + ": Chapter " + QString::number(iChapterCount,10));
    qry.bindValue(":courseid", iCourseID);
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }
    qDebug() << "iChapterID " << qry.lastInsertId();
    qDebug() << "iChapterCount " << iChapterCount;
//    qry2.bindValue(":wordid", qry.lastInsertId());
    return qry.lastInsertId().toInt();
}

void importflashcard::createWord(int iChapterID, QStringList strList)
{
    QSqlQuery qry;
    QSqlQuery qry2;

    qry.prepare("INSERT INTO words (side1, side2, side3, side4) VALUES "
                "(:side1, :side2, :side3, :side4)");

    qry.bindValue(":side1", "");
    qry.bindValue(":side2", "");
    qry.bindValue(":side3", "");
    qry.bindValue(":side4", "");


    switch (strList.count()){
        case 4:
            qry.bindValue(":side4", strList[3]);
        case 3:
            qry.bindValue(":side3", strList[2]);
        case 2:
            qry.bindValue(":side2", strList[1]);
        case 1:
            qry.bindValue(":side1", strList[0]);
    }

/*
    qry.bindValue(":side1", strList[0]);
    qry.bindValue(":side2", strList[1]);
    qry.bindValue(":side3", strList[2]);
    qry.bindValue(":side4", strList[3]);
*/
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
        qDebug() << qry.executedQuery();
        qDebug() << qry.boundValues();
    }

    qry2.prepare("INSERT INTO chapterwords (lessonid, wordid, score, scoredelta) VALUES "
                "(:lessonid, :wordid, :score, :scoredelta)");
    qry2.bindValue(":score", 20);
    qry2.bindValue(":scoredelta", 0);
    qry2.bindValue(":lessonid", iChapterID);
    qry2.bindValue(":wordid", qry.lastInsertId());
    qry2.bindValue(":score", 20);
    qry2.bindValue(":scoredelta", 0);
    if (!qry2.exec())
    {
        qDebug() << qry2.lastQuery();
        qDebug() << qry2.lastError();
    }

}

void importflashcard::createDatabase()
{

    QSqlDatabase db;

    db = QSqlDatabase::addDatabase("QSQLITE");

    #ifdef Q_OS_LINUX
                // NOTE: We have to store database file into user home folder in Linux
                QString path(QDir::home().path());
                path.append(QDir::separator()).append("qteachme.db");
                path = QDir::toNativeSeparators(path);
        qDebug() << "Db path:" << path;
                db.setDatabaseName(path);
    #else
                // NOTE: File exists in the application private folder, in Symbian Qt implementation
                db.setDatabaseName("qteachme.db");
    #endif

    if (!db.open())
    {
        qDebug() << "Failed to connect";
        qDebug() << db.lastError();
    }

    QSqlQuery qry;

    if (!qry.exec("CREATE TABLE IF NOT EXISTS words "
        "(side1 VARCHAR(80), side2 VARCHAR(40), side3 VARCHAR(10), "
        "side4 VARCHAR(10), audio VARCHAR(80), image VARCHAR(80), video VARCHAR(80))"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (!qry.exec("CREATE TABLE IF NOT EXISTS settings "
        "(courseid INT, chapterid INT, username VARCHAR(80))"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    qry.prepare("INSERT INTO settings (courseid, chapterid) VALUES "
                "(1, 1)");
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (!qry.exec("CREATE TABLE IF NOT EXISTS courses "
                  "(name VARCHAR(40), courseid SMALLINT,"
                  "side1 VARCHAR(20), side2 VARCHAR(20), side3 VARCHAR(20), side4 VARCHAR(20), "
                  "showside1 SMALLINT, showside2 SMALLINT, showside3 SMALLINT, showside4 SMALLINT, "
                  "sortby SMALLINT, selectby SMALLINT)"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (!qry.exec("CREATE TABLE IF NOT EXISTS chapters (name VARCHAR(40), "
                  "courseid INT)"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (!qry.exec("CREATE TABLE IF NOT EXISTS chapterwords (wordid SMALLINT, lessonid SMALLINT, score SMALLINT, scoredelta SMALLINT)"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }
}

void importflashcard::purgeDatabase()
{
    QSqlQuery qry;

    if (!qry.exec("DELETE FROM settings"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (!qry.exec("DELETE FROM words"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (!qry.exec("DELETE FROM courses"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (!qry.exec("DELETE FROM chapters"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (!qry.exec("DELETE FROM chapterwords"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }
}
