#include "filterselectoraction.h"

#include <QMaemo5ValueButton>
#include <QDebug>
#include "categoryeditor.h"
#include "todomodel.h"

CategorySelectorAction::CategorySelectorAction(QWidget *parent) :
    QWidgetAction(parent)
{
}

QWidget* CategorySelectorAction::createWidget(QWidget* parent)
{

    TodoModel* m = TodoModel::instance();
    QMaemo5ValueButton* b = new QMaemo5ValueButton(parent);
    b->setText("Filter");;
    b->setValueText(m->currentCategory());
    connect(b, SIGNAL(clicked()), this, SLOT(doPopup()));

    return b;
}

void CategorySelectorAction::doPopup()
{
    qDebug() << "popup";
    CategoryEditor* ce = new CategoryEditor(parentWidget());
    TodoModel* m = TodoModel::instance();

    connect(ce, SIGNAL(categorySelected(QString)), m, SLOT(setCurrentCategory(QString)));
    ce->show();

}
