#include "folderview.h"
#include <QVBoxLayout>
#include "todomodel.h"
#include <QDebug>

#include "taskeditor.h"

FolderView::FolderView(QWidget *parent) :
    QWidget(parent)
{
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    setWindowFlags(windowFlags() | Qt::Window);
    QVBoxLayout* l = new QVBoxLayout(this);

    m_list = new QListWidget(this);
    l->addWidget(m_list);
    setLayout(l);

    connect(m_list, SIGNAL(itemActivated(QListWidgetItem*)), this, SLOT(itemSelected(QListWidgetItem*)));
    connect(TodoModel::instance(), SIGNAL(updatedFolder(QString)), this, SLOT(folderUpdated(QString)));
}

void FolderView::setName(const QString& name)
{
    m_name = name;

    /*
    QString s = name;
    QString cat = TodoModel::instance()->currentCategory();
    if (cat.length()) {
        s.append(QString(" [%1]").arg(cat));

    }
    */
    //setWindowTitle(s);
    populate();

}

void FolderView::populate()
{
    QList<TaskEntry> tasks;
    TodoModel* m = TodoModel::instance();
    m->getTasksForFolder(m_name, tasks);
    m_list->clear();
    foreach (const TaskEntry& t, tasks) {
        QListWidgetItem* it = new QListWidgetItem(t.desc);
        it->setData(Qt::UserRole, t.id);
        m_list->addItem(it);
    }
    QString title = m_name;

    QString cat = m->currentCategory();
    if (cat.length()) {
        title.append(QString(" [%1]").arg(cat));
    }
    setWindowTitle(title);






}

void FolderView::itemSelected(QListWidgetItem *item)
{
    int iid = item->data(Qt::UserRole).toInt();

    qDebug() << "Selected" << iid;


    TaskEntry t = TodoModel::instance()->findById(iid);

    TaskEditor* te = new TaskEditor(t, this);

    te->show();
}

void FolderView::folderUpdated(const QString &folder)
{
    if (folder == m_name) {
        populate();
    }
}





