#include "mainwindow.h"
#include "ui_mainwindow.h"

#include "dialogpreferences.h"


// TODO calculate freq depending on time thinking

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{

	menuBar()->clear();
	//menuBar()->addAction(tr("About"), this, SLOT(about()));
	menuBar()->addAction(tr("Options"), this, SLOT(options()));
	menuBar()->addAction(tr("Exit"), QApplication::instance(), SLOT(quit()));

    timer = NULL;

    QCoreApplication::setOrganizationName("nowheremanmail");
    QCoreApplication::setOrganizationDomain("gmail.com");
    QCoreApplication::setApplicationName("qtCalculus");

    ui->setupUi(this);

    //ui->centralWidget->setLayout(new QHBoxLayout);

    currentItem = NULL;
    numbers = new RandomNumbers;

    think ();
}

void MainWindow::options () {
    DialogPreferences * d = new DialogPreferences;
    d->exec();

    numbers->prepare ();
    think ();

    delete d;
}

void MainWindow::fail(int t) {
    numbers->update(currentItem, 1, 0);
}

void MainWindow::ok() {
    timer->stop();
    numbers->update(currentItem, 0, ticks);
}

void MainWindow::onTick() {
    ticks++;
}

void MainWindow::think () {
    ticks = 0;
    if (timer == NULL) {
        timer = new QTimer(this);
        timer->start(1000);
    }
    else {
        timer->stop();
        timer->start(1000);
    }

    QObject::connect(timer,SIGNAL(timeout()),this,SLOT(onTick()));

    current = "";

    currentItem = numbers->next();

    operation = currentItem->operation;
    mode = currentItem->mode;

    switch (mode) {
    case 1:
        number1 = -1;
        number0 = currentItem->num0;
        result = currentItem->result;
        break;
    case 0:
        number1 = currentItem->num1;
        number0 = -1;
        result = currentItem->result;
        break;
    case 2:
        number1 = currentItem->num1;
        number0 = currentItem->num0;
        result = -1;
        break;
    }

    show1 (number1);
    show0 (number0);
    showResult (result);
    showOperation (operation);

    // TODO fail = 0, time = 0
}

void MainWindow::showOperation(int n) {
    switch (n) {
    case PRODUCT:
        ui->operation->setText("x");
        break;
    case SUM:
        ui->operation->setText("+");
        break;
    case MINUS:
        ui->operation->setText("-");
        break;
    }
}

void MainWindow::show1(int n) {
    if (n < 0) {
        ui->label_1_1->setText(" ");
        ui->label_1_0->setText("?");
    }
    else {
        ui->label_1_1->setText(QString (" 123456789").at(n / 10));
        ui->label_1_0->setText(QString ("0123456789").at(n % 10));
    }
}
void MainWindow::show0(int n) {
    if (n < 0) {
        ui->label_0_1->setText(" ");
        ui->label_0_0->setText("?");
    }
    else {
        ui->label_0_1->setText(QString (" 123456789").at(n / 10));
        ui->label_0_0->setText(QString ("0123456789").at(n % 10));
    }
}
void MainWindow::showResult(int n) {
    if (n < 0) {
        ui->result1->setText(" ");
        ui->result0->setText("?");
    }
    else {
        ui->result1->setText(QString (" 123456789").at(n / 10));
        ui->result0->setText(QString ("0123456789").at(n % 10));
    }
}

MainWindow::~MainWindow()
{
    delete ui;
}
void MainWindow::set(char c) {
    if (current.length() < 2) {
        current = current + c;
    }
    else {
        fail (1);
    }

    int tmp = current.toInt();

    switch (mode) {
    case 1:
        number1 = tmp;
        show1(number1);
        break;
    case 0:
        number0 = tmp;
        show0(number0);
        break;
    case 2:
        result = tmp;
        showResult(result);
        break;
    }
}
void MainWindow::on_pushButtonOK_clicked()
{
    confirm ();
}
void MainWindow::confirm() {
    bool isOk = false;

    switch (operation) {
    case PRODUCT: // x
        isOk = (number1 * number0) == result;
        break;
    case SUM: // +
        isOk = (number1 + number0) == result;
        break;
    case MINUS: // -
        isOk = (number1 - number0) == result;
        break;
    }


    if (isOk) {
        ok ();
        think ();
    }
    else {
        fail (0);
        clear ();
    }
}
void MainWindow::clear() {
    current = "";
    switch (mode) {
    case 1:
        number1 = -1;
        show1(number1);
        break;
    case 0:
        number0 = -1;
        show0(number0);
        break;
    case 2:
        result = -1;
        showResult(result);
        break;
    }
}
void MainWindow::on_pushButtonCL_clicked()
{
    clear ();
}

void MainWindow::on_pushButton0_clicked()
{
    set('0');
}
void MainWindow::on_pushButton1_clicked()
{
    set('1');
}
void MainWindow::on_pushButton2_clicked()
{
    set('2');
}
void MainWindow::on_pushButton3_clicked()
{
    set('3');
}
void MainWindow::on_pushButton4_clicked()
{
    set('4');
}
void MainWindow::on_pushButton5_clicked()
{
    set('5');
}
void MainWindow::on_pushButton6_clicked()
{
    set('6');
}
void MainWindow::on_pushButton7_clicked()
{
    set('7');
}
void MainWindow::on_pushButton8_clicked()
{
    set('8');
}
void MainWindow::on_pushButton9_clicked()
{
    set('9');
}




