//    QtBatteryWidget
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#ifndef SETTINGS_H
#define SETTINGS_H

#include <QObject>
#include <QSettings>

class Settings : public QObject
{
    Q_OBJECT
public:
    enum PercSource
    {
        SourceDefault = 0,
        SourceBq27200,
        SourceDrFrost,
    };

    enum PercStyles
    {
        StyleGraphical = 0,
        StyleStandard,
        StyleTextual,
    };

    explicit Settings(QObject *parent = 0);

    PercSource PercType;
    PercStyles PercStyle;
    float PercScale;
    int Opacity;
    bool ShowLabels;
    bool ShowCharge;
    bool ShowVoltage;
    bool ShowRemaining;
    bool ShowTemp;

    static QString GetConfigName();
    bool Load();
    bool Save();

    static void RemoveWidget(QString appletId);
    static QList<QString> GetAppletIds();
    static void SaveAppletIds(QList<QString> ids);

signals:

public slots:

};

#endif // SETTINGS_H
