//    QtBatteryWidget
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#ifndef BATTERYWIDGET_H
#define BATTERYWIDGET_H

#include <QWidget>
class BatteryWidget : public QWidget
{
    Q_OBJECT
public:
    explicit BatteryWidget(QWidget *parent = 0);
    ~BatteryWidget();

    void SetLevels(int low, int critical);
    void SetBackgroundImage(QPixmap background);
    void SetCriticalLevelImage(QPixmap image);
    void SetLowLevelImage(QPixmap image);
    void SetNormalLevelImage(QPixmap image);

    void SetRange(int min, int max);    
    void SetInsideMargins(int left, int top, int right, int bottom);
    int Value();
    int Maximum();
    int Minimum();

    void SetIsCharging(bool charging);

private:
    int m_CriticalLevel;
    int m_LowLevel;

    int m_Max;
    int m_Min;
    int m_Value;
    float m_Perc;

    QMargins m_Margins;

    QString m_ValueStr;
    QSize m_ValueStrSize;
    QSize m_InsideSize;

    QPixmap* m_Background;
    QPixmap* m_State;
    QPixmap* m_Critical;
    QPixmap* m_Low;
    QPixmap* m_Normal;

    bool m_Charging;

protected:
    void paintEvent(QPaintEvent* event);
    void resizeEvent(QResizeEvent* event);

signals:

public slots:
    void SetValue(int value, bool updateLabel=true);
};

#endif // BATTERYWIDGET_H
