//    QtBatteryWidget
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "settingsdialog.h"
#include "ui_settingsdialog.h"
#include "commonstatic.h"
#include "aboutwindow.h"

SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog)
{
    ui->setupUi(this);

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5NonComposited, true);
    //setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif

    ui->cmbChargeType->setEnabled(CommonStatic::Bq27x00Present(this));

    ui->cmbChargeType->addItem(tr("Default"), Settings::SourceDefault);
    ui->cmbChargeType->addItem(tr("bq27200"), Settings::SourceBq27200);

    ui->cmbStyle->addItem(tr("Graphical"), Settings::StyleGraphical);
    ui->cmbStyle->addItem(tr("Standard"), Settings::StyleStandard);
    ui->cmbStyle->addItem(tr("Textual"), Settings::StyleTextual);

    connect(ui->btnSalva, SIGNAL(clicked()), this, SLOT(accept()));

    ui->cmbChargeType->setCurrentIndex(CommonStatic::CurrentSettings->PercType);
    ui->cmbStyle->setCurrentIndex(CommonStatic::CurrentSettings->PercStyle);
    connect(ui->cmbStyle, SIGNAL(currentIndexChanged(int)), this, SLOT(StyleChangedSlot(int)));
    ui->chkLabels->setChecked(CommonStatic::CurrentSettings->ShowLabels);
    ui->chkCharge->setChecked(CommonStatic::CurrentSettings->ShowCharge);
    ui->chkVoltage->setChecked(CommonStatic::CurrentSettings->ShowVoltage);
    ui->chkRemaining->setChecked(CommonStatic::CurrentSettings->ShowRemaining);
    ui->chkTemp->setChecked(CommonStatic::CurrentSettings->ShowTemp);

    connect(ui->sliOpacity, SIGNAL(valueChanged(int)), this, SLOT(OpacityChangedSlot(int)));    
    connect(ui->sliScale, SIGNAL(valueChanged(int)), this, SLOT(ScaleChangedSlot(int)));
    connect(ui->btnAbout, SIGNAL(clicked()), this, SLOT(AboutSlot()));
    ui->sliOpacity->setValue(CommonStatic::CurrentSettings->Opacity);
    ui->sliScale->setValue(CommonStatic::CurrentSettings->PercScale * 100);
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::accept()
{
    CommonStatic::CurrentSettings->PercType = (Settings::PercSource)ui->cmbChargeType->currentIndex();
    CommonStatic::CurrentSettings->PercStyle = (Settings::PercStyles)ui->cmbStyle->currentIndex();
    CommonStatic::CurrentSettings->ShowLabels = ui->chkLabels->isChecked();
    CommonStatic::CurrentSettings->ShowCharge = ui->chkCharge->isChecked();
    CommonStatic::CurrentSettings->ShowVoltage = ui->chkVoltage->isChecked();
    CommonStatic::CurrentSettings->ShowRemaining = ui->chkRemaining->isChecked();
    CommonStatic::CurrentSettings->ShowTemp= ui->chkTemp->isChecked();

    CommonStatic::CurrentSettings->Opacity = ui->sliOpacity->value();
    CommonStatic::CurrentSettings->PercScale = (float)ui->sliScale->value() / 100.0;

    CommonStatic::CurrentSettings->Save();
    QDialog::accept();
}

void SettingsDialog::OpacityChangedSlot(int value)
{
    ui->lblOpacity->setText(tr("Opacity: %1").arg(value));
}

void SettingsDialog::ScaleChangedSlot(int value)
{
    ui->lblScale->setText(tr("Percentage Size: %1%").arg(value));
}

void SettingsDialog::AboutSlot()
{
    AboutWindow* frm = new AboutWindow(this);
    frm->Init();
    frm->exec();
    delete frm;
}

void SettingsDialog::StyleChangedSlot(int style)
{
    ui->sliScale->setEnabled((Settings::PercStyles)style == Settings::StyleGraphical);
}
