//    QtBatteryWidget
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "settings.h"
#include "commonstatic.h"
#include <QFile>
#include <QDebug>

Settings::Settings(QObject *parent) :
    QObject(parent)
{
    PercType = SourceDefault;
    Opacity = 185;
    ShowLabels = true;
    ShowVoltage= true;    
    ShowCharge = true;
    ShowRemaining = true;
    ShowTemp = true;
}

QString Settings::GetConfigName()
{
    QString folder = CommonStatic::GetSettingsFolder();
    return QString("%1/settings.conf").arg(folder);
}

bool Settings::Load()
{
    if (!QFile::exists(GetConfigName()))
        return false;

    qDebug() << "Loading settings";
    QSettings* settings = new QSettings(GetConfigName(), QSettings::IniFormat);

    settings->beginGroup("Main");

    PercType = (PercSource)settings->value("PercType", SourceDefault).toInt();
    PercStyle = (PercStyles)settings->value("PercStyle", StyleGraphical).toInt();
    Opacity = settings->value("Opacity", 185).toInt();
    ShowLabels = settings->value("ShowLabels", true).toBool();
    ShowCharge = settings->value("ShowCharge", true).toBool();
    ShowVoltage = settings->value("ShowVoltage", true).toBool();
    ShowRemaining = settings->value("ShowRemaining", true).toBool();
    ShowTemp = settings->value("ShowTemp", true).toBool();

    settings->endGroup();
    delete settings;
    return true;
}

bool Settings::Save()
{
    qDebug() << "Saving settings";
    QSettings* settings = new QSettings(GetConfigName(), QSettings::IniFormat);

    settings->beginGroup("Main");

    settings->setValue("PercType", PercType);
    settings->setValue("PercStyle", PercStyle);
    settings->setValue("Opacity", Opacity);
    settings->setValue("ShowLabels", ShowLabels);
    settings->setValue("ShowCharge", ShowCharge);
    settings->setValue("ShowVoltage", ShowVoltage);
    settings->setValue("ShowRemaining", ShowRemaining);
    settings->setValue("ShowTemp", ShowTemp);

    settings->endGroup();
    settings->sync();

    delete settings;
    return true;
}

QList<QString> Settings::GetAppletIds()
{
    QList<QString> res;
    if (!QFile::exists(GetConfigName()))
        return res;

    qDebug() << "Loading appletids";
    QSettings* settings = new QSettings(GetConfigName(), QSettings::IniFormat);

    settings->beginGroup("Main");
    int size = settings->beginReadArray("appletids");
    for (int i = 0; i < size; ++i) {
        settings->setArrayIndex(i);
        res.append(settings->value("appletid").toString());
    }
    settings->endArray();
    settings->endGroup();
    delete settings;

    return res;
}

void Settings::SaveAppletIds(QList<QString> ids)
{
    qDebug() << "Saving appletids";
    QSettings* settings = new QSettings(GetConfigName(), QSettings::IniFormat);

    settings->beginGroup("Main");
    settings->beginWriteArray("appletids");
    int size = ids.count();
    for (int i = 0; i < size; ++i) {
        settings->setArrayIndex(i);
        settings->setValue("appletid", ids.at(i));
    }
    settings->endArray();
    settings->endGroup();
    settings->sync();
}

void Settings::RemoveWidget(QString appletId)
{
    QList<QString> appletIds = GetAppletIds();
    appletIds.removeAll(appletId);
    SaveAppletIds(appletIds);

    QSettings* settings = new QSettings(GetConfigName(), QSettings::IniFormat);
    settings->remove(appletId);
    settings->sync();
}

