/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the Qt Designer of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain
** additional rights. These rights are described in the Nokia Qt LGPL
** Exception version 1.0, included in the file LGPL_EXCEPTION.txt in this
** package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at http://www.qtsoftware.com/contact.
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QACTIVEXPLUGINOBJECT_H
#define QACTIVEXPLUGINOBJECT_H

#include <QtCore/QPointer>
#include <QtCore/QMap>
#include <QtGui/QWidget>
#include <QtGui/QPixmap>

QT_BEGIN_NAMESPACE

class QAxWidget;

/* QDesignerAxWidget aggregates QAxWidget to keep it out of the event loop while applying
 * properties directly.
 * Thus, it is possible to set property values in designer that are out of range
 * for the control, which might cause it to throw exceptions.
 *
 * QDesignerAxWidget is the base class following the internal naming
 * conventions that makes the control property visible to the introspection interface.
 *
 * The trick to aggregate a QAxWidget is to overwrite the metaObject() function
 * generated by moc to return the QMetaObject of QAxWidget. This is what QDesignerAxPluginWidget does. */

class QDesignerAxWidget : public QWidget
{
    Q_OBJECT
    Q_PROPERTY(QString control READ control WRITE setControl RESET resetControl DESIGNABLE true)
    Q_DISABLE_COPY(QDesignerAxWidget)

protected:
    explicit QDesignerAxWidget(QWidget *parent);

public:
    virtual ~QDesignerAxWidget();

    bool loadControl(const QString &clsid);

    void resetControl();
    void setControl(const QString &clsid);
    QString control() const;

    QSize sizeHint() const;
    QSize minimumSizeHint() const;

    bool loaded() { return (m_axobject != 0); }

    static QPixmap widgetIcon();

    enum { DrawIndicator = 0x1, DrawFrame = 0x2, DrawControl = 0x4 };

    unsigned drawFlags() const { return m_drawFlags; }
    void setDrawFlags(unsigned f)  { m_drawFlags = f; }

protected:
    void paintEvent(QPaintEvent *event);
    QAxWidget *axobject() const { return m_axobject; }

private:
    const QSize m_defaultSize;
    unsigned m_drawFlags;
    QAxWidget *m_axobject;
    QPixmap m_axImage;
};

class QDesignerAxPluginWidget : public QDesignerAxWidget
{
   // No Q_OBJECT here! - meta functionality is overriden
public:
    explicit QDesignerAxPluginWidget(QWidget *parent);
    virtual ~QDesignerAxPluginWidget();

    virtual const QMetaObject *metaObject() const;
    virtual int qt_metacall(QMetaObject::Call, int, void **);

private:
    QMap<int, bool> m_propValues;
};

#if defined Q_CC_MSVC && _MSC_VER < 1300
template <> inline QDesignerAxWidget *qobject_cast_helper<QDesignerAxWidget*>(QObject *o,  QDesignerAxWidget*)
#else
template <> inline QDesignerAxWidget *qobject_cast<QDesignerAxWidget*>(QObject *o)
#endif
{
    if (!o)
        return 0;

    // Unloaded state
    if (strcmp(o->metaObject()->className(), "QDesignerAxWidget") == 0)
        return static_cast<QDesignerAxPluginWidget*>(o);

    // Loaded state with fake meta object
    if (strcmp(o->metaObject()->className(), "QAxWidget") == 0)
        return static_cast<QDesignerAxPluginWidget*>(o);

    return 0;
}

QT_END_NAMESPACE

#endif // ACTIVEQT_EXTRAINFO_H
