/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(WORKERS)

#include "JSWorkerNavigator.h"

#include <wtf/GetPtr.h>

#include "KURL.h"
#include "WorkerNavigator.h"

#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSWorkerNavigator)

/* Hash table */

static const HashTableValue JSWorkerNavigatorTableValues[6] =
{
    { "appName", DontDelete|ReadOnly, (intptr_t)jsWorkerNavigatorAppName, (intptr_t)0 },
    { "appVersion", DontDelete|ReadOnly, (intptr_t)jsWorkerNavigatorAppVersion, (intptr_t)0 },
    { "platform", DontDelete|ReadOnly, (intptr_t)jsWorkerNavigatorPlatform, (intptr_t)0 },
    { "userAgent", DontDelete|ReadOnly, (intptr_t)jsWorkerNavigatorUserAgent, (intptr_t)0 },
    { "onLine", DontDelete|ReadOnly, (intptr_t)jsWorkerNavigatorOnLine, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSWorkerNavigatorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 511, JSWorkerNavigatorTableValues, 0 };
#else
    { 18, 15, JSWorkerNavigatorTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSWorkerNavigatorPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSWorkerNavigatorPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSWorkerNavigatorPrototypeTableValues, 0 };
#else
    { 1, 0, JSWorkerNavigatorPrototypeTableValues, 0 };
#endif

static const HashTable* getJSWorkerNavigatorPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSWorkerNavigatorPrototypeTable);
}
const ClassInfo JSWorkerNavigatorPrototype::s_info = { "WorkerNavigatorPrototype", 0, 0, getJSWorkerNavigatorPrototypeTable };

JSObject* JSWorkerNavigatorPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWorkerNavigator>(exec, globalObject);
}

static const HashTable* getJSWorkerNavigatorTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSWorkerNavigatorTable);
}
const ClassInfo JSWorkerNavigator::s_info = { "WorkerNavigator", 0, 0, getJSWorkerNavigatorTable };

JSWorkerNavigator::JSWorkerNavigator(PassRefPtr<Structure> structure, PassRefPtr<WorkerNavigator> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSWorkerNavigator::~JSWorkerNavigator()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSWorkerNavigator::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSWorkerNavigatorPrototype(JSWorkerNavigatorPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSWorkerNavigator::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWorkerNavigator, Base>(exec, getJSWorkerNavigatorTable(exec), this, propertyName, slot);
}

JSValuePtr jsWorkerNavigatorAppName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    WorkerNavigator* imp = static_cast<WorkerNavigator*>(static_cast<JSWorkerNavigator*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->appName());
}

JSValuePtr jsWorkerNavigatorAppVersion(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    WorkerNavigator* imp = static_cast<WorkerNavigator*>(static_cast<JSWorkerNavigator*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->appVersion());
}

JSValuePtr jsWorkerNavigatorPlatform(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    WorkerNavigator* imp = static_cast<WorkerNavigator*>(static_cast<JSWorkerNavigator*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->platform());
}

JSValuePtr jsWorkerNavigatorUserAgent(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    WorkerNavigator* imp = static_cast<WorkerNavigator*>(static_cast<JSWorkerNavigator*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->userAgent());
}

JSValuePtr jsWorkerNavigatorOnLine(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    WorkerNavigator* imp = static_cast<WorkerNavigator*>(static_cast<JSWorkerNavigator*>(asObject(slot.slotBase()))->impl());
    return jsBoolean(imp->onLine());
}

JSC::JSValuePtr toJS(JSC::ExecState* exec, WorkerNavigator* object)
{
    return getDOMObjectWrapper<JSWorkerNavigator>(exec, object);
}
WorkerNavigator* toWorkerNavigator(JSC::JSValuePtr value)
{
    return value->isObject(&JSWorkerNavigator::s_info) ? static_cast<JSWorkerNavigator*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WORKERS)
