/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "SVGElement.h"
#include "JSSVGRenderingIntent.h"

#include <wtf/GetPtr.h>

#include "SVGRenderingIntent.h"

#include <runtime/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGRenderingIntent)

/* Hash table */

static const HashTableValue JSSVGRenderingIntentTableValues[2] =
{
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsSVGRenderingIntentConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGRenderingIntentTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGRenderingIntentTableValues, 0 };
#else
    { 2, 1, JSSVGRenderingIntentTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSSVGRenderingIntentConstructorTableValues[7] =
{
    { "RENDERING_INTENT_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGRenderingIntentRENDERING_INTENT_UNKNOWN, (intptr_t)0 },
    { "RENDERING_INTENT_AUTO", DontDelete|ReadOnly, (intptr_t)jsSVGRenderingIntentRENDERING_INTENT_AUTO, (intptr_t)0 },
    { "RENDERING_INTENT_PERCEPTUAL", DontDelete|ReadOnly, (intptr_t)jsSVGRenderingIntentRENDERING_INTENT_PERCEPTUAL, (intptr_t)0 },
    { "RENDERING_INTENT_RELATIVE_COLORIMETRIC", DontDelete|ReadOnly, (intptr_t)jsSVGRenderingIntentRENDERING_INTENT_RELATIVE_COLORIMETRIC, (intptr_t)0 },
    { "RENDERING_INTENT_SATURATION", DontDelete|ReadOnly, (intptr_t)jsSVGRenderingIntentRENDERING_INTENT_SATURATION, (intptr_t)0 },
    { "RENDERING_INTENT_ABSOLUTE_COLORIMETRIC", DontDelete|ReadOnly, (intptr_t)jsSVGRenderingIntentRENDERING_INTENT_ABSOLUTE_COLORIMETRIC, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGRenderingIntentConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSSVGRenderingIntentConstructorTableValues, 0 };
#else
    { 16, 15, JSSVGRenderingIntentConstructorTableValues, 0 };
#endif

class JSSVGRenderingIntentConstructor : public DOMObject {
public:
    JSSVGRenderingIntentConstructor(ExecState* exec)
        : DOMObject(JSSVGRenderingIntentConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSSVGRenderingIntentPrototype::self(exec, exec->lexicalGlobalObject()), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSSVGRenderingIntentConstructor::s_info = { "SVGRenderingIntentConstructor", 0, &JSSVGRenderingIntentConstructorTable, 0 };

bool JSSVGRenderingIntentConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGRenderingIntentConstructor, DOMObject>(exec, &JSSVGRenderingIntentConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSSVGRenderingIntentPrototypeTableValues[7] =
{
    { "RENDERING_INTENT_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGRenderingIntentRENDERING_INTENT_UNKNOWN, (intptr_t)0 },
    { "RENDERING_INTENT_AUTO", DontDelete|ReadOnly, (intptr_t)jsSVGRenderingIntentRENDERING_INTENT_AUTO, (intptr_t)0 },
    { "RENDERING_INTENT_PERCEPTUAL", DontDelete|ReadOnly, (intptr_t)jsSVGRenderingIntentRENDERING_INTENT_PERCEPTUAL, (intptr_t)0 },
    { "RENDERING_INTENT_RELATIVE_COLORIMETRIC", DontDelete|ReadOnly, (intptr_t)jsSVGRenderingIntentRENDERING_INTENT_RELATIVE_COLORIMETRIC, (intptr_t)0 },
    { "RENDERING_INTENT_SATURATION", DontDelete|ReadOnly, (intptr_t)jsSVGRenderingIntentRENDERING_INTENT_SATURATION, (intptr_t)0 },
    { "RENDERING_INTENT_ABSOLUTE_COLORIMETRIC", DontDelete|ReadOnly, (intptr_t)jsSVGRenderingIntentRENDERING_INTENT_ABSOLUTE_COLORIMETRIC, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGRenderingIntentPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSSVGRenderingIntentPrototypeTableValues, 0 };
#else
    { 16, 15, JSSVGRenderingIntentPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGRenderingIntentPrototype::s_info = { "SVGRenderingIntentPrototype", 0, &JSSVGRenderingIntentPrototypeTable, 0 };

JSObject* JSSVGRenderingIntentPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGRenderingIntent>(exec, globalObject);
}

bool JSSVGRenderingIntentPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGRenderingIntentPrototype, JSObject>(exec, &JSSVGRenderingIntentPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGRenderingIntent::s_info = { "SVGRenderingIntent", 0, &JSSVGRenderingIntentTable, 0 };

JSSVGRenderingIntent::JSSVGRenderingIntent(PassRefPtr<Structure> structure, PassRefPtr<SVGRenderingIntent> impl, SVGElement* context)
    : DOMObject(structure)
    , m_context(context)
    , m_impl(impl)
{
}

JSSVGRenderingIntent::~JSSVGRenderingIntent()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSSVGRenderingIntent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGRenderingIntentPrototype(JSSVGRenderingIntentPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSSVGRenderingIntent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGRenderingIntent, Base>(exec, &JSSVGRenderingIntentTable, this, propertyName, slot);
}

JSValuePtr jsSVGRenderingIntentConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSSVGRenderingIntent*>(asObject(slot.slotBase()))->getConstructor(exec);
}
JSValuePtr JSSVGRenderingIntent::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSSVGRenderingIntentConstructor>(exec);
}

// Constant getters

JSValuePtr jsSVGRenderingIntentRENDERING_INTENT_UNKNOWN(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValuePtr jsSVGRenderingIntentRENDERING_INTENT_AUTO(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValuePtr jsSVGRenderingIntentRENDERING_INTENT_PERCEPTUAL(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSValuePtr jsSVGRenderingIntentRENDERING_INTENT_RELATIVE_COLORIMETRIC(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(3));
}

JSValuePtr jsSVGRenderingIntentRENDERING_INTENT_SATURATION(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(4));
}

JSValuePtr jsSVGRenderingIntentRENDERING_INTENT_ABSOLUTE_COLORIMETRIC(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(5));
}

JSC::JSValuePtr toJS(JSC::ExecState* exec, SVGRenderingIntent* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGRenderingIntent>(exec, object, context);
}
SVGRenderingIntent* toSVGRenderingIntent(JSC::JSValuePtr value)
{
    return value->isObject(&JSSVGRenderingIntent::s_info) ? static_cast<JSSVGRenderingIntent*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
