/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG) && ENABLE(SVG_FILTERS)

#include "SVGElement.h"
#include "JSSVGFEComponentTransferElement.h"

#include <wtf/GetPtr.h>

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedString.h"
#include "SVGFEComponentTransferElement.h"

#include <runtime/Error.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGFEComponentTransferElement)

/* Hash table */

static const HashTableValue JSSVGFEComponentTransferElementTableValues[9] =
{
    { "in1", DontDelete|ReadOnly, (intptr_t)jsSVGFEComponentTransferElementIn1, (intptr_t)0 },
    { "x", DontDelete|ReadOnly, (intptr_t)jsSVGFEComponentTransferElementX, (intptr_t)0 },
    { "y", DontDelete|ReadOnly, (intptr_t)jsSVGFEComponentTransferElementY, (intptr_t)0 },
    { "width", DontDelete|ReadOnly, (intptr_t)jsSVGFEComponentTransferElementWidth, (intptr_t)0 },
    { "height", DontDelete|ReadOnly, (intptr_t)jsSVGFEComponentTransferElementHeight, (intptr_t)0 },
    { "result", DontDelete|ReadOnly, (intptr_t)jsSVGFEComponentTransferElementResult, (intptr_t)0 },
    { "className", DontDelete|ReadOnly, (intptr_t)jsSVGFEComponentTransferElementClassName, (intptr_t)0 },
    { "style", DontDelete|ReadOnly, (intptr_t)jsSVGFEComponentTransferElementStyle, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGFEComponentTransferElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 255, JSSVGFEComponentTransferElementTableValues, 0 };
#else
    { 18, 15, JSSVGFEComponentTransferElementTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGFEComponentTransferElementPrototypeTableValues[2] =
{
    { "getPresentationAttribute", DontDelete|Function, (intptr_t)jsSVGFEComponentTransferElementPrototypeFunctionGetPresentationAttribute, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGFEComponentTransferElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGFEComponentTransferElementPrototypeTableValues, 0 };
#else
    { 2, 1, JSSVGFEComponentTransferElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGFEComponentTransferElementPrototype::s_info = { "SVGFEComponentTransferElementPrototype", 0, &JSSVGFEComponentTransferElementPrototypeTable, 0 };

JSObject* JSSVGFEComponentTransferElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGFEComponentTransferElement>(exec, globalObject);
}

bool JSSVGFEComponentTransferElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGFEComponentTransferElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGFEComponentTransferElement::s_info = { "SVGFEComponentTransferElement", &JSSVGElement::s_info, &JSSVGFEComponentTransferElementTable, 0 };

JSSVGFEComponentTransferElement::JSSVGFEComponentTransferElement(PassRefPtr<Structure> structure, PassRefPtr<SVGFEComponentTransferElement> impl)
    : JSSVGElement(structure, impl)
{
}

JSObject* JSSVGFEComponentTransferElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGFEComponentTransferElementPrototype(JSSVGFEComponentTransferElementPrototype::createStructure(JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGFEComponentTransferElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFEComponentTransferElement, Base>(exec, &JSSVGFEComponentTransferElementTable, this, propertyName, slot);
}

JSValuePtr jsSVGFEComponentTransferElementIn1(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEComponentTransferElement* imp = static_cast<SVGFEComponentTransferElement*>(static_cast<JSSVGFEComponentTransferElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedString> obj = imp->in1Animated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGFEComponentTransferElementX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEComponentTransferElement* imp = static_cast<SVGFEComponentTransferElement*>(static_cast<JSSVGFEComponentTransferElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->xAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGFEComponentTransferElementY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEComponentTransferElement* imp = static_cast<SVGFEComponentTransferElement*>(static_cast<JSSVGFEComponentTransferElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->yAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGFEComponentTransferElementWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEComponentTransferElement* imp = static_cast<SVGFEComponentTransferElement*>(static_cast<JSSVGFEComponentTransferElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->widthAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGFEComponentTransferElementHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEComponentTransferElement* imp = static_cast<SVGFEComponentTransferElement*>(static_cast<JSSVGFEComponentTransferElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->heightAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGFEComponentTransferElementResult(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEComponentTransferElement* imp = static_cast<SVGFEComponentTransferElement*>(static_cast<JSSVGFEComponentTransferElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedString> obj = imp->resultAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGFEComponentTransferElementClassName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEComponentTransferElement* imp = static_cast<SVGFEComponentTransferElement*>(static_cast<JSSVGFEComponentTransferElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGFEComponentTransferElementStyle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEComponentTransferElement* imp = static_cast<SVGFEComponentTransferElement*>(static_cast<JSSVGFEComponentTransferElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->style()));
}

JSValuePtr jsSVGFEComponentTransferElementPrototypeFunctionGetPresentationAttribute(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGFEComponentTransferElement::s_info))
        return throwError(exec, TypeError);
    JSSVGFEComponentTransferElement* castedThisObj = static_cast<JSSVGFEComponentTransferElement*>(asObject(thisValue));
    SVGFEComponentTransferElement* imp = static_cast<SVGFEComponentTransferElement*>(castedThisObj->impl());
    const UString& name = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->getPresentationAttribute(name)));
    return result;
}


}

#endif // ENABLE(SVG) && ENABLE(SVG_FILTERS)
