/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLOptGroupElement.h"

#include <wtf/GetPtr.h>

#include "HTMLOptGroupElement.h"
#include "KURL.h"

#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLOptGroupElement)

/* Hash table */

static const HashTableValue JSHTMLOptGroupElementTableValues[4] =
{
    { "disabled", DontDelete, (intptr_t)jsHTMLOptGroupElementDisabled, (intptr_t)setJSHTMLOptGroupElementDisabled },
    { "label", DontDelete, (intptr_t)jsHTMLOptGroupElementLabel, (intptr_t)setJSHTMLOptGroupElementLabel },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLOptGroupElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLOptGroupElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 63, JSHTMLOptGroupElementTableValues, 0 };
#else
    { 10, 7, JSHTMLOptGroupElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLOptGroupElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLOptGroupElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLOptGroupElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLOptGroupElementConstructorTableValues, 0 };
#endif

class JSHTMLOptGroupElementConstructor : public DOMObject {
public:
    JSHTMLOptGroupElementConstructor(ExecState* exec)
        : DOMObject(JSHTMLOptGroupElementConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSHTMLOptGroupElementPrototype::self(exec, exec->lexicalGlobalObject()), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSHTMLOptGroupElementConstructor::s_info = { "HTMLOptGroupElementConstructor", 0, &JSHTMLOptGroupElementConstructorTable, 0 };

bool JSHTMLOptGroupElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLOptGroupElementConstructor, DOMObject>(exec, &JSHTMLOptGroupElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLOptGroupElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLOptGroupElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLOptGroupElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSHTMLOptGroupElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLOptGroupElementPrototype::s_info = { "HTMLOptGroupElementPrototype", 0, &JSHTMLOptGroupElementPrototypeTable, 0 };

JSObject* JSHTMLOptGroupElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLOptGroupElement>(exec, globalObject);
}

const ClassInfo JSHTMLOptGroupElement::s_info = { "HTMLOptGroupElement", &JSHTMLElement::s_info, &JSHTMLOptGroupElementTable, 0 };

JSHTMLOptGroupElement::JSHTMLOptGroupElement(PassRefPtr<Structure> structure, PassRefPtr<HTMLOptGroupElement> impl)
    : JSHTMLElement(structure, impl)
{
}

JSObject* JSHTMLOptGroupElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLOptGroupElementPrototype(JSHTMLOptGroupElementPrototype::createStructure(JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLOptGroupElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLOptGroupElement, Base>(exec, &JSHTMLOptGroupElementTable, this, propertyName, slot);
}

JSValuePtr jsHTMLOptGroupElementDisabled(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLOptGroupElement* imp = static_cast<HTMLOptGroupElement*>(static_cast<JSHTMLOptGroupElement*>(asObject(slot.slotBase()))->impl());
    return jsBoolean(imp->disabled());
}

JSValuePtr jsHTMLOptGroupElementLabel(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLOptGroupElement* imp = static_cast<HTMLOptGroupElement*>(static_cast<JSHTMLOptGroupElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->label());
}

JSValuePtr jsHTMLOptGroupElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLOptGroupElement*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSHTMLOptGroupElement::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLOptGroupElement, Base>(exec, propertyName, value, &JSHTMLOptGroupElementTable, this, slot);
}

void setJSHTMLOptGroupElementDisabled(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLOptGroupElement* imp = static_cast<HTMLOptGroupElement*>(static_cast<JSHTMLOptGroupElement*>(thisObject)->impl());
    imp->setDisabled(value->toBoolean(exec));
}

void setJSHTMLOptGroupElementLabel(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLOptGroupElement* imp = static_cast<HTMLOptGroupElement*>(static_cast<JSHTMLOptGroupElement*>(thisObject)->impl());
    imp->setLabel(valueToStringWithNullCheck(exec, value));
}

JSValuePtr JSHTMLOptGroupElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSHTMLOptGroupElementConstructor>(exec);
}


}
