/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the QtGui module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QMAEMO5KINETICSCROLLER_H
#define QMAEMO5KINETICSCROLLER_H

#include <QtCore/qobject.h>

QT_BEGIN_HEADER

QT_BEGIN_NAMESPACE

QT_MODULE(Gui)

#ifdef Q_WS_MAEMO_5

class QMaemo5KineticScrollerPrivate;
class QWidget;

class Q_GUI_EXPORT QMaemo5KineticScroller : public QObject
{
    Q_OBJECT
public:
    QMaemo5KineticScroller(QWidget *areaToScroll);
    virtual ~QMaemo5KineticScroller();

protected:
    bool eventFilter(QObject *o, QEvent *e);
    void timerEvent(QTimerEvent *te);

    QMaemo5KineticScroller(QMaemo5KineticScrollerPrivate &dd, QWidget *areaToScroll);

    QScopedPointer<QMaemo5KineticScrollerPrivate> d_ptr;

private:
    Q_DISABLE_COPY(QMaemo5KineticScroller)
    Q_DECLARE_PRIVATE(QMaemo5KineticScroller)
};

#endif // Q_WS_MAEMO_5

QT_END_NAMESPACE

QT_END_HEADER

#endif // QMAEMO5KINETICSCROLLER_H
