/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** This file is part of the QtGui module of the Qt Toolkit.
**
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the file LICENSE.GPL included in
** the packaging of this file.  Please review the following information
** to ensure GNU General Public Licensing requirements will be met:
** http://www.fsf.org/licensing/licenses/info/GPLv2.html and
** http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
** exception, Nokia gives you certain additional rights. These rights
** are described in the Nokia Qt GPL Exception version 1.3, included in
** the file GPL_EXCEPTION.txt in this package.
**
** Qt for Windows(R) Licensees
** As a special exception, Nokia, as the sole copyright holder for Qt
** Designer, grants users of the Qt/Eclipse Integration plug-in the
** right for the Qt/Eclipse Integration to link to functionality
** provided by Qt Designer and its related libraries.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
**
****************************************************************************/

#ifndef QMAEMOS5STYLE_H
#define QMAEMOS5STYLE_H

#include <QtGui/QGtkStyle>
#include <QtGui/QPalette>
#include <QtGui/QFont>

QT_BEGIN_HEADER

QT_BEGIN_NAMESPACE

QT_MODULE(Gui)

#if defined(Q_WS_MAEMO_5)

class QPainterPath;
class QMaemo5StylePrivate;

class Q_GUI_EXPORT QMaemo5Style : public QGtkStyle
{
    Q_OBJECT
    Q_DECLARE_PRIVATE(QMaemo5Style)

public:
    QMaemo5Style();
    ~QMaemo5Style();

    enum PrimitiveElement {
        PE_Maemo5InformationBox = PE_CustomBase / 2,
        PE_Maemo5AppMenu
    };

    enum PixelMetric {
        PM_Maemo5AppMenuHorizontalSpacing = PM_CustomBase / 2,
        PM_Maemo5AppMenuVerticalSpacing,
        PM_Maemo5AppMenuContentMargin,
        PM_Maemo5AppMenuLandscapeXOffset,
        PM_Maemo5AppMenuFilterGroupWidth,
        PM_Maemo5AppMenuFilterGroupVerticalSpacing,
    };

    // QPalette standardPalette() const;

    void drawPrimitive(QStyle::PrimitiveElement element, const QStyleOption *option,
                       QPainter *painter, const QWidget *widget) const;
    void drawControl(ControlElement control, const QStyleOption *option,
                     QPainter *painter, const QWidget *widget) const;
    void drawComplexControl(ComplexControl control, const QStyleOptionComplex *option,
                            QPainter *painter, const QWidget *widget) const;

    int pixelMetric(QStyle::PixelMetric metric, const QStyleOption *option = 0,
                    const QWidget *widget = 0) const;
    int styleHint(StyleHint hint, const QStyleOption *option,
                  const QWidget *widget, QStyleHintReturn *returnData) const;

    QStyle::SubControl hitTestComplexControl(ComplexControl cc, const QStyleOptionComplex *opt,
                              const QPoint &pt, const QWidget *w) const;

    QRect subControlRect(ComplexControl control, const QStyleOptionComplex *option,
                         SubControl subControl, const QWidget *widget) const;
    QRect subElementRect(SubElement sr, const QStyleOption *opt, const QWidget *w) const;

    QSize sizeFromContents(ContentsType type, const QStyleOption *option,
                           const QSize &size, const QWidget *widget) const;

    void polish(QApplication *app);
    void polish(QWidget *widget);
    void unpolish(QWidget *widget);
};


#endif //defined(Q_WS_MAEMO_5)

QT_END_NAMESPACE

QT_END_HEADER

#endif //QMAEMOS5STYLE_H
