/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the Qt Mobility Components.
**
** $QT_BEGIN_LICENSE:LGPL$
** GNU Lesser General Public License Usage
** This file may be used under the terms of the GNU Lesser General Public
** License version 2.1 as published by the Free Software Foundation and
** appearing in the file LICENSE.LGPL included in the packaging of this
** file. Please review the following information to ensure the GNU Lesser
** General Public License version 2.1 requirements will be met:
** http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU General
** Public License version 3.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of this
** file. Please review the following information to ensure the GNU General
** Public License version 3.0 requirements will be met:
** http://www.gnu.org/copyleft/gpl.html.
**
** Other Usage
** Alternatively, this file may be used in accordance with the terms and
** conditions contained in a signed written agreement between you and Nokia.
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QCAMERACONTROL_H
#define QCAMERACONTROL_H

#include <qmediacontrol.h>
#include <qmediaobject.h>

#include <qcamera.h>

QT_BEGIN_NAMESPACE

class Q_MULTIMEDIA_EXPORT QCameraControl : public QMediaControl
{
    Q_OBJECT

public:
    enum PropertyChangeType {
        CaptureMode = 1,
        ImageEncodingSettings = 2,
        VideoEncodingSettings = 3,
        Viewfinder = 4
    };

    ~QCameraControl();

    virtual QCamera::State state() const = 0;
    virtual void setState(QCamera::State state) = 0;

    virtual QCamera::Status status() const = 0;

    virtual QCamera::CaptureMode captureMode() const = 0;
    virtual void setCaptureMode(QCamera::CaptureMode) = 0;
    virtual bool isCaptureModeSupported(QCamera::CaptureMode mode) const = 0;

    virtual bool canChangeProperty(PropertyChangeType changeType, QCamera::Status status) const = 0;

Q_SIGNALS:
    void stateChanged(QCamera::State);
    void statusChanged(QCamera::Status);
    void error(int error, const QString &errorString);
    void captureModeChanged(QCamera::CaptureMode);

protected:
    QCameraControl(QObject* parent = 0);
};

#define QCameraControl_iid "com.nokia.Qt.QCameraControl/1.0"
Q_MEDIA_DECLARE_CONTROL(QCameraControl, QCameraControl_iid)

QT_END_NAMESPACE

#endif  // QCAMERACONTROL_H

