/****************************************************************************
**
** Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the Qt Mobility Components.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial Usage
** Licensees holding valid Qt Commercial licenses may use this file in 
** accordance with the Qt Commercial License Agreement provided with
** the Software or, alternatively, in accordance with the terms
** contained in a written agreement between you and Nokia.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QGEOMAPROUTEOBJECT_H
#define QGEOMAPROUTEOBJECT_H

#include "qgeomapobject.h"
#include "qgeoroute.h"

#include <QPen>

QTM_BEGIN_NAMESPACE

class QGeoMapRouteObjectPrivate;
class QGeoRoute;
class QGeoCoordinate;

class Q_LOCATION_EXPORT QGeoMapRouteObject : public QGeoMapObject
{
    Q_OBJECT
    Q_PROPERTY(QGeoRoute route READ route WRITE setRoute NOTIFY routeChanged)
    Q_PROPERTY(QPen pen READ pen WRITE setPen NOTIFY penChanged)
    Q_PROPERTY(quint32 detailLevel READ detailLevel WRITE setDetailLevel NOTIFY detailLevelChanged)

public:
    QGeoMapRouteObject();
    QGeoMapRouteObject(const QGeoRoute &route);
    ~QGeoMapRouteObject();

    QGeoMapObject::Type type() const;

    QGeoRoute route() const;
    void setRoute(const QGeoRoute &route);

    QPen pen() const;
    void setPen(const QPen &pen);

    quint32 detailLevel() const;
    void setDetailLevel(quint32 detailLevel);

Q_SIGNALS:
    void routeChanged(const QGeoRoute &route);
    void penChanged(const QPen &pen);
    void detailLevelChanged(quint32 detailLevel);

private:
    QGeoMapRouteObjectPrivate *d_ptr;
    Q_DECLARE_PRIVATE(QGeoMapRouteObject)
    Q_DISABLE_COPY(QGeoMapRouteObject)
};

QTM_END_NAMESPACE

#endif
