/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the Qt Mobility Components.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include "n900lightsensor.h"
#include <QDebug>
#include <time.h>

const char *n900lightsensor::id("n900.ambientlight");

n900lightsensor::n900lightsensor(QSensor *sensor)
    : n900filebasedsensor(sensor)
    , m_filename(LIGHTSENSOR_FILE)
{
    setReading<QAmbientLightReading>(&m_reading);
}

void n900lightsensor::poll()
{
    m_reading.setTimestamp(clock());
    FILE *fd = fopen(m_filename, "r");
    if (!fd) return;
    int lux;
    int rs = fscanf(fd, "%i", &lux);
    fclose(fd);
    if (rs != 1) return;

    QAmbientLightReading::LightLevel lightLevel = QAmbientLightReading::Undefined;
    if (lux < 10)
        lightLevel = QAmbientLightReading::Dark;
    else if (lux < 50)
        lightLevel = QAmbientLightReading::Twilight;
    else if (lux < 100)
        lightLevel = QAmbientLightReading::Light;
    else if (lux < 150)
        lightLevel = QAmbientLightReading::Bright;
    else
        lightLevel = QAmbientLightReading::Sunny;

    m_reading.setLightLevel(lightLevel);

    newReadingAvailable();
}

