/****************************************************************************
**
** Copyright (C) 2007-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the Graphics Dojo project on Trolltech Labs.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/
#ifndef CONTEXT2D_H
#define CONTEXT2D_H

#include <QPainter>
#include <QString>
#include <QStack>
#include <QWidget>
#include <QMetaType>


class Context2D : public QObject
{
    Q_OBJECT

    // compositing
    Q_PROPERTY(float globalAlpha READ globalAlpha WRITE setGlobalAlpha)
    Q_PROPERTY(QString globalCompositeOperation READ globalCompositeOperation WRITE setGlobalCompositeOperation)
    Q_PROPERTY(QString strokeStyle READ strokeStyle WRITE setStrokeStyle)
    Q_PROPERTY(QString fillStyle READ fillStyle WRITE setFillStyle)
    // line caps/joins
    Q_PROPERTY(float lineWidth READ lineWidth WRITE setLineWidth)
    Q_PROPERTY(QString lineCap READ lineCap WRITE setLineCap)
    Q_PROPERTY(QString lineJoin READ lineJoin WRITE setLineJoin)
    Q_PROPERTY(float miterLimit READ miterLimit WRITE setMiterLimit)
    // shadows
    Q_PROPERTY(float shadowOffsetX READ shadowOffsetX WRITE setShadowOffsetX)
    Q_PROPERTY(float shadowOffsetY READ shadowOffsetY WRITE setShadowOffsetY)
    Q_PROPERTY(float shadowBlur READ shadowBlur WRITE setShadowBlur)
    Q_PROPERTY(QColor shadowColor READ shadowColor WRITE setShadowColor)

public:
    Context2D(QWidget *parent);
    void setSize(int w, int h);
    
    void begin();
    const QPixmap & end();

    // compositing
    float globalAlpha() const; // (default 1.0)
    QString globalCompositeOperation() const; // (default over)
    QString strokeStyle() const; // (default black)
    QString fillStyle() const; // (default black)

    void setGlobalAlpha(float alpha);
    void setGlobalCompositeOperation(const QString &op);
    void setStrokeStyle(const QString &style);
    void setFillStyle(const QString &style);

    // line caps/joins
    float lineWidth() const; // (default 1)
    QString lineCap() const; // "butt", "round", "square" (default "butt")
    QString lineJoin() const; // "round", "bevel", "miter" (default "miter")
    float miterLimit() const; // (default 10)

    void setLineWidth(float w);
    void setLineCap(const QString &s);
    void setLineJoin(const QString &s);
    void setMiterLimit(float m);

    // shadows
    float shadowOffsetX() const; // (default 0)
    float shadowOffsetY() const; // (default 0)
    float shadowBlur() const; // (default 0)
    QColor shadowColor() const; // (default black)

    void setShadowOffsetX(float x);
    void setShadowOffsetY(float y);
    void setShadowBlur(float b);
    void setShadowColor(const QColor &c);

public slots:
    void save(); // push state on state stack
    void restore(); // pop state stack and restore state

    void scale(float x, float y);
    void rotate(float angle);
    void translate(float x, float y);
    void transform(float m11, float m12, float m21, float m22,
                   float dx, float dy);
    void setTransform(float m11, float m12, float m21, float m22,
                      float dx, float dy);

    // rects
    void clearRect(float x, float y, float w, float h);
    void fillRect(float x, float y, float w, float h);
    void strokeRect(float x, float y, float w, float h);

    // path API
    void beginPath();
    void closePath();
    void moveTo(float x, float y);
    void lineTo(float x, float y);
    void quadraticCurveTo(float cpx, float cpy, float x, float y);
    void bezierCurveTo(float cp1x, float cp1y,
                       float cp2x, float cp2y, float x, float y);
    void arcTo(float x1, float y1, float x2, float y2, float radius);
    void rect(float x, float y, float w, float h);
    void arc(float x, float y, float radius,
             float startAngle, float endAngle,
             bool anticlockwise);
    void fill();
    void stroke();
    void clip();
    bool isPointInPath(float x, float y) const;
private:
    QPixmap  m_cache;
    QPainter m_painter;
    QPainterPath m_path;
    struct State {
        State()
            : creatingShape(false)
        {}

        QMatrix      matrix;
        bool         creatingShape;
    };
    State m_state;
    QStack<State> m_stateStack;
};

#endif
