/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef WEBHISTORYINTERFACE_P_H
#define WEBHISTORYINTERFACE_P_H

class WebHistoryInterface
{

    Q_PROPERTY(stringlist urls READ urls)
    Q_PROPERTY(int count READ count NOTIFY urlsChanged)
    Q_PROPERTY(string storageFileName READ storageFileName WRITE setStorageFileName)

public:
    bool save();
    bool load();
    void clear();

/*!
    \class WebHistoryInterface
    \brief WebHistoryInterface is a global context property providing access to the 
    global web history
    
    \ingroup org-hildon-webkit
    \ingroup org-hildon-webkit-properties
    
    \note This component cannot be created in QML.
*/

/*!
    \property stringlist WebHistoryInterface::urls
    \brief The list of urls in the history
*/

/*!
    \property count WebHistoryInterface::count
    \brief The current number of items in the history
*/

/*!
    \property string WebHistoryInterface::storageFileName
    \brief The file name used to (re)store the history
*/

/*!
    \fn bool WebHistoryInterface::save()
    
    Returns true if the history can be saved to \link storageFileName\endlink.
*/

/*!
    \fn bool WebHistoryInterface::load()
    
    Returns true if the history can be loaded from \link storageFileName\endlink.
*/

/*!
    \fn void WebHistoryInterface::clear()
    
    Clears all items from the history.
*/

};

#endif // WEBHISTORYINTERFACE_P_H
