/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef WEBHISTORY_P_H
#define WEBHISTORY_P_H

class WebHistory
{

    Q_PROPERTY(list<jsobject> backItems READ backItems CONSTANT)
    Q_PROPERTY(list<jsobject> forwardItems READ forwardItems CONSTANT)
    Q_PROPERTY(list<jsobject> items READ items CONSTANT)
    Q_PROPERTY(jsobject backItem READ backItem)
    Q_PROPERTY(jsobject forwardItem READ forwardItem)
    Q_PROPERTY(jsobject currentItem READ currentItem)
    Q_PROPERTY(int currentIndex READ currentIndex WRITE setCurrentIndex)
    Q_PROPERTY(int maximumItemCount READ maximumItemCount WRITE setMaximumItemCount)
    Q_PROPERTY(int count READ count CONSTANT)
    Q_PROPERTY(bool canGoBack READ canGoBack)
    Q_PROPERTY(bool canGoForward READ canGoForward)
    Q_PROPERTY(string storageFileName READ storageFileName WRITE setStorageFileName)

public:
    jsobject itemAt(int index);

    bool save();
    bool load();
    void clear();

/*!
    \class WebHistory
    \brief The WebHistory component provides access to the web history 
    of a WebPage or WebView 
    
    \ingroup org-hildon-webkit
    
    \note This component cannot be created in QML.
    
    \sa WebPage, WebView
*/

/*!
    \property list<jsobject> WebHistory::backItems
    \brief The list of back items in the history
*/

/*!
    \property list<jsobject> WebHistory::forwardItems
    \brief The list of forward items in the history
*/

/*!
    \property jsobject WebHistory::backItem
    \brief The most previous item in the history
*/

/*!
    \property jsobject WebHistory::forwardItem
    \brief The next item in the history
*/

/*!
    \property jsobject WebHistory::currentItem
    \brief The current item in the history
*/

/*!
    \property int WebHistory::currentIndex
    \brief The index of the current item in the history
*/

/*!
    \property int WebHistory::maximumItemCount
    \brief The maximum number of items in the history
*/

/*!
    \property count WebHistory::count
    \brief The current number of items in the history
*/

/*!
    \property bool WebHistory::canGoBack
    \brief Whether there is a back item available
*/

/*!
    \property bool WebHistory::canGoForward
    \brief Whether there is a forward item available
*/

/*!
    \property string WebHistory::storageFileName
    \brief The file name used to (re)store the history
*/

/*!
    \fn jsobject WebHistory::itemAt(int index)
    
    Returns the history item at \a index.
*/

/*!
    \fn bool WebHistory::save()
    
    Returns true if the history can be saved to \link storageFileName\endlink.
*/

/*!
    \fn bool WebHistory::load()
    
    Returns true if the history can be loaded from \link storageFileName\endlink.
*/

/*!
    \fn void WebHistory::clear()
    
    Clears all items from the history.
*/

};

#endif // WEBHISTORY_P_H
