/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef CLIPBOARD_P_H
#define CLIPBOARD_P_H

class Clipboard
{
    Q_OBJECT

    Q_PROPERTY(variant pixmap READ pixmap WRITE setPixmap)
    Q_PROPERTY(string text READ text WRITE setText)
    Q_PROPERTY(bool hasPixmap READ hasPixmap)
    Q_PROPERTY(bool hasText READ hasText)

signals:
    void dataChanged();
    
/*!
    \class Clipboard
    \brief Clipboard is a global context property providing access to the system clipboard
    
    \ingroup org-hildon-utils
    \ingroup org-hildon-utils-properties
    
    \code
    Label {
        id: label
        
        contextMenuPolicy: Qt.ActionsContextMenu
        actions: Action {
            text: "Set text from clipboard"
            enabled: clipboard.hasText
            onTriggered: label.text = clipboard.text
        }
    }
    \endcode
    
    \note Clipboard is a context property and cannot be created in QML.
*/

/*!
    \property variant Clipboard::pixmap
    \brief The pixmap copied to the clipboard, if any
    
    \sa dataChanged()
*/

/*!
    \property string Clipboard::text
    \brief The text copied to the clipboard, if any
    
    \sa dataChanged()
*/

/*!
    \property bool Clipboard::hasPixmap
    \brief Whether a pixmap is available
    
    \sa dataChanged()
*/

/*!
    \property bool Clipboard::hasText
    \brief Whether text is available
    
    \sa dataChanged()
*/

/*!
    \fn void Clipboard::dataChanged()
    
    This signal is emitted when the data of the clipboard 
    changes.
*/

};

#endif // CLIPBOARD_P_H
