/****************************************************************************
**
** Copyright (C) 2013 Digia Plc and/or its subsidiary(-ies).
** Contact: http://www.qt-project.org/legal
**
** This file is part of the examples of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Digia.  For licensing terms and
** conditions see http://qt.digia.com/licensing.  For further information
** use the contact form at http://qt.digia.com/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Digia gives you certain additional
** rights.  These rights are described in the Digia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef SETTINGS_P_H
#define SETTINGS_P_H

class Settings
{
    Q_OBJECT

    Q_PROPERTY(string fileName READ fileName WRITE setFileName)
    Q_PROPERTY(string category READ category WRITE setCategory)

/*!
    \class Settings
    \brief The Settings component exposes the 
    <a href="http://qt-project.org/doc/qt-4.7/qsettings.html">QSettings</a> API to QML
    
    \ingroup org-hildon-settings
    
    Each Settings instance can have a \link fileName\endlink and a \link category\endlink.
    Properties declared in QML will be automatically (re)stored.
    
    \code
    Settings {
        id: settings
        
        fileName: "/home/user/.config/MyApplication/settings.conf"
        category: "MyCategory"
        
        property string foo: "bar"
    }
    \endcode
    
    settings.conf
    
    \code
    [MyCategory]
    foo=bar
    \endcode
*/

/*!
    \property string Settings::fileName
    \brief The location of the file where the settings will be stored
    
    By default, this property is an empty string, meaning that the location 
    will be determined by QApplication::organizationName() and 
    QApplication::applicationName().
*/

/*!
    \property string Settings::category
    \brief The category under which settings will be (re)stored
*/

};

#endif // SETTINGS_P_H
