/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef WINDOW_P_H
#define WINDOW_P_H

class Window : public Item
{

    Q_PROPERTY(PageStack pageStack READ pageStack CONSTANT)
    Q_PROPERTY(enumeration orientationLock READ orientationLock WRITE setOrientationLock)
    Q_PROPERTY(bool inPortrait READ inPortrait NOTIFY inPortraitChanged)
    Q_PROPERTY(bool fullScreen READ isFullScreen WRITE setFullScreen)
    Q_PROPERTY(bool showProgressIndicator READ showingProgressIndicator WRITE showProgressIndicator)
    Q_PROPERTY(list<Object> tools READ tools)

/*!
    \class Window
    \brief The Window component provides a top-level window in an application
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-controls
    
    A typical application will have only one Window, although 
    it is possible to have multiple windows.
*/

/*!
    \property PageStack Window::pageStack
    \brief The window's PageStack object
    
    Each Window has a PageStack, and this is used to 'push' stacked 
    pages in order to display new content. Pages can be 'popped' from 
    the stack either programmatically, or when the user clicks the 'back'
    button.
    
    \sa PageStack, Page
*/

/*!
    \property enumeration Window::orientationLock
    \brief The allowed orientation(s) of the window
    
    Possible values are:
    
    \li \c Screen.LandscapeOrientation - The window is locked to landscape.
    \li \c Screen.PortraitOrientation - The window is locked to portrait.
    \li \c Screen.AutoOrientation - The window's orientation changes when 
    the device is rotated.
    
    The default value is \c Screen.LandscapeOrientation.
    
    \sa Screen
*/

/*!
    \property bool Window::inPortrait
    \brief Whether the window's orientation is \c Screen.PortraitOrientation
    
    \sa orientationLock
*/

/*!
    \property bool Window::fullScreen
    \brief Whether the window is displayed in fullScreen
    
    The default value is \a false.
*/

/*!
    \property bool Window::showProgressIndicator
    \brief Whether the progress indicator is visible
    
    The default value is \a false.
*/

/*!
    \property list<Object> Window::tools
    \brief The window's tools that appear in the menu
    
    Actions assigned to the window's tools will appear in 
    the menu. Adding an ActionGroup with child actions 
    will add a filter group to the menu.
    
    \sa Action, ActionGroup
*/

};

#endif // WINDOW_P_H
