/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef TOOLBUTTONSTYLE_P_H
#define TOOLBUTTONSTYLE_P_H

class ToolButtonStyle : public Style
{
    
    Q_PROPERTY(Style menuButton READ menuButton WRITE setMenuButton)
    Q_PROPERTY(Style menuIndicator READ menuIndicator WRITE setMenuIndicator)
    Q_PROPERTY(Style downArrow READ downArrow WRITE setDownArrow)
    Q_PROPERTY(Style leftArrow READ leftArrow WRITE setLeftArrow)
    Q_PROPERTY(Style rightArrow READ rightArrow WRITE setRightArrow)
    Q_PROPERTY(Style upArrow READ upArrow WRITE setUpArrow)
    
/*!
    \class ToolButtonStyle
    \brief ToolButtonStyle is a styling component for ToolButton
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-style
    
    \sa ToolButton
*/

/*!
    \property Style ToolButtonStyle::menuButton
    \brief Applies styling properties to the menu button of the 
    ToolButton
*/

/*!
    \property Style ToolButtonStyle::menuIndicator
    \brief Applies styling properties to the menu indicator of the 
    ToolButton
*/

/*!
    \property Style ToolButtonStyle::downArrow
    \brief Applies styling properties to the down arrow of the 
    ToolButton
*/

/*!
    \property Style ToolButtonStyle::leftArrow
    \brief Applies styling properties to the left arrow of the 
    ToolButton
*/

/*!
    \property Style ToolButtonStyle::rightArrow
    \brief Applies styling properties to the right arrow of the 
    ToolButton
*/

/*!
    \property Style ToolButtonStyle::upArrow
    \brief Applies styling properties to the up arrow of the 
    ToolButton
*/

};

#endif // TOOLBUTTONSTYLE_P_H

