/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */
 
#ifndef STYLE_P_H
#define STYLE_P_H

class Style
{
    
    Q_PROPERTY(enumeration backgroundClip READ backgroundClip WRITE setBackgroundClip)
    Q_PROPERTY(color backgroundColor READ backgroundColor WRITE setBackgroundColor)
    Q_PROPERTY(string backgroundImage READ backgroundImage WRITE setBackgroundImage)
    Q_PROPERTY(enumeration backgroundOrigin READ backgroundOrigin WRITE setBackgroundOrigin)
    Q_PROPERTY(flags backgroundPosition READ backgroundPosition WRITE setBackgroundPosition)
    Q_PROPERTY(enumeration backgroundRepeat READ backgroundRepeat WRITE setBackgroundRepeat)
    Q_PROPERTY(color borderColor READ borderColor WRITE setBorderColor)
    Q_PROPERTY(color borderColorTop READ borderColorTop WRITE setBorderColorTop)
    Q_PROPERTY(color borderColorRight READ borderColorRight WRITE setBorderColorRight)
    Q_PROPERTY(color borderColorBottom READ borderColorBottom WRITE setBorderColorBottom)
    Q_PROPERTY(color borderColorLeft READ borderColorLeft WRITE setBorderColorLeft)
    Q_PROPERTY(string borderImage READ borderImage WRITE setBorderImage)
    Q_PROPERTY(int borderRadius READ borderRadius WRITE setBorderRadius)
    Q_PROPERTY(int borderRadiusTopLeft READ borderRadiusTopLeft WRITE setBorderRadiusTopLeft)
    Q_PROPERTY(int borderRadiusTopRight READ borderRadiusTopRight WRITE setBorderRadiusTopRight)
    Q_PROPERTY(int borderRadiusBottomRight READ borderRadiusBottomRight WRITE setBorderRadiusBottomRight)
    Q_PROPERTY(int borderRadiusBottomLeft READ borderRadiusBottomLeft WRITE setBorderRadiusBottomLeft)
    Q_PROPERTY(enumeration borderStyle READ borderStyle WRITE setBorderStyle)
    Q_PROPERTY(int borderWidth READ borderWidth WRITE setBorderWidth)
    Q_PROPERTY(int borderWidthTop READ borderWidthTop WRITE setBorderWidthTop)
    Q_PROPERTY(int borderWidthRight READ borderWidthRight WRITE setBorderWidthRight)
    Q_PROPERTY(int borderWidthBottom READ borderWidthBottom WRITE setBorderWidthBottom)
    Q_PROPERTY(int borderWidthLeft READ borderWidthLeft WRITE setBorderWidthLeft)
    Q_PROPERTY(string image READ image WRITE setImage)
    Q_PROPERTY(flags imagePosition READ imagePosition WRITE setImagePosition)
    Q_PROPERTY(int margin READ margin WRITE setMargin)
    Q_PROPERTY(int marginTop READ marginTop WRITE setMarginTop)
    Q_PROPERTY(int marginRight READ marginRight WRITE setMarginRight)
    Q_PROPERTY(int marginBottom READ marginBottom WRITE setMarginBottom)
    Q_PROPERTY(int marginLeft READ marginLeft WRITE setMarginLeft)
    Q_PROPERTY(int minimumWidth READ minimumWidth WRITE setMinimumWidth)
    Q_PROPERTY(int maximumWidth READ maximumWidth WRITE setMaximumWidth)
    Q_PROPERTY(int minimumHeight READ minimumHeight WRITE setMinimumHeight)
    Q_PROPERTY(int maximumHeight READ maximumHeight WRITE setMaximumHeight)
    Q_PROPERTY(int padding READ padding WRITE setPadding)
    Q_PROPERTY(int paddingTop READ paddingTop WRITE setPaddingTop)
    Q_PROPERTY(int paddingRight READ paddingRight WRITE setPaddingRight)
    Q_PROPERTY(int paddingBottom READ paddingBottom WRITE setPaddingBottom)
    Q_PROPERTY(int paddingLeft READ paddingLeft WRITE setPaddingLeft)
    Q_PROPERTY(color textColor READ textColor WRITE setTextColor)
    
/*!
    \class Style
    \brief Style is a styling component for Item
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-style
    
    The Style component provides styling properties that 
    are applied to any Item which has its style property 
    set to the particular Style instance.
*/

/*!
    \property enumeration Style::backgroundClip
    \brief The rectangle to which the background-color and background-image are clipped
    
    Possible values are:
    
    \li \c Margin - The margin rectangle. The margin falls outside the border.
    \li \c Border - The border rectangle. This is where any border is drawn.
    \li \c Padding - The padding rectangle. Unlike the margins, padding is 
    located inside the border.
    \li \c Content - The content rectangle. This specifies where the actual contents go, 
    excluding any padding, border, or margin.
    
    The default value is \c Border.
*/

/*!
    \property color Style::backgroundColor
    \brief The background color used for the item
*/

/*!
    \property string Style::backgroundImage
    \brief The source of the background image used for the item
*/

/*!
    \property enumeration Style::backgroundOrigin
    \brief The item's background rectangle, to use in conjunction with 
    backgroundPosition and backgroundImage.
    
    Possible values are:
    
    \li \c Margin - The margin rectangle. The margin falls outside the border.
    \li \c Border - The border rectangle. This is where any border is drawn.
    \li \c Padding - The padding rectangle. Unlike the margins, padding is 
    located inside the border.
    \li \c Content - The content rectangle. This specifies where the actual contents go, 
    excluding any padding, border, or margin.
    
    The default value is \c Padding.
*/

/*!
    \property flags Style::backgroundPosition
    \brief The alignment of the background image within the backgroundOrigin rectangle
*/

/*!
    \property enumeration Style::backgroundRepeat
    \brief Whether and how the background image is repeated to fill the backgroundOrigin rectangle.

    Possible values are:
    
    \li \c RepeatX - Repeat horizontally.
    \li \c RepeatY - Repeat vertically.
    \li \c RepeatXandY - Repeat horizontally and vertically.
    \li \c NoRepeat - Don't repeat.
    
    The default value is RepeatXandY.
*/

/*!
    \property color Style::borderColor
    \brief The border color used for the item
*/

/*!
    \property color Style::borderColorTop
    \brief The top border color used for the item
*/

/*!
    \property color Style::borderColorRight
    \brief The right border color used for the item
*/

/*!
    \property color Style::borderColorBottom
    \brief The bottom border color used for the item
*/

/*!
    \property color Style::borderColorLeft
    \brief The left border color used for the item
*/

/*!
    \property string Style::borderImage
    \brief The source of the border image used for the item
*/

/*!
    \property int Style::borderRadius
    \brief The radius of the border used for the item
*/

/*!
    \property int Style::borderRadiusTopLeft
    \brief The top-left radius of the border used for the item
*/

/*!
    \property int Style::borderRadiusTopRight
    \brief The top-right radius of the border used for the item
*/

/*!
    \property int Style::borderRadiusBottomRight
    \brief The bottom-right radius of the border used for the item
*/

/*!
    \property int Style::borderRadiusBottomLeft
    \brief The bottom-left radius of the border used for the item
*/

/*!
    \property enumeration Style::borderStyle
    \brief The pattern used to draw the border for the item
    
    Possible values are:
    
    \li \c Dashed
    \li \c DotDash
    \li \c DotDotDash
    \li \c Dotted
    \li \c Double
    \li \c Groove
    \li \c Inset
    \li \c Outset
    \li \c Ridge
    \li \c Solid
    \li \c None
    
    The default value is \c None.
*/

/*!
    \property int Style::borderWidth
    \brief The width of the border used for the item
*/

/*!
    \property int Style::borderWidthTop
    \brief The top width of the border used for the item
*/

/*!
    \property int Style::borderWidthRight
    \brief The right width of the border used for the item
*/

/*!
    \property int Style::borderWidthBottom
    \brief The bottom width of the border used for the item
*/

/*!
    \property int Style::borderWidthLeft
    \brief The left width of the border used for the item
*/

/*!
    \property string Style::image
    \brief The source of the image used for the item
*/

/*!
    \property flags Style::imagePosition
    \brief The alignment of the image used for the item
*/

/*!
    \property int Style::margin
    \brief The margin used for the item
*/

/*!
    \property int Style::marginTop
    \brief The top margin used for the item
*/

/*!
    \property int Style::marginRight
    \brief The right margin used for the item
*/

/*!
    \property int Style::marginBottom
    \brief The bottom margin used for the item
*/

/*!
    \property int Style::marginLeft
    \brief The left margin used for the item
*/

/*!
    \property int Style::minimumWidth
    \brief The minimum width used for the item
*/

/*!
    \property int Style::maximumWidth
    \brief The maximum width used for the item
*/

/*!
    \property int Style::minimumHeight
    \brief The minimum height used for the item
*/

/*!
    \property int Style::maximumHeight
    \brief The maximum height used for the item
*/

/*!
    \property int Style::padding
    \brief The padding used for the item
*/

/*!
    \property int Style::paddingTop
    \brief The top padding used for the item
*/

/*!
    \property int Style::paddingRight
    \brief The right padding used for the item
*/

/*!
    \property int Style::paddingBottom
    \brief The bottom padding used for the item
*/

/*!
    \property int Style::paddingLeft
    \brief The left padding used for the item
*/

/*!
    \property color Style::textColor
    \brief The text color used for the item
*/

};

#endif // STYLE_P_H

