/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef SPINBOXSTYLE_P_H
#define SPINBOXSTYLE_P_H

class SpinBoxStyle : public Style
{
    
    Q_PROPERTY(Style downArrow READ downArrow WRITE setDownArrow)
    Q_PROPERTY(Style downButton READ downButton WRITE setDownButton)
    Q_PROPERTY(Style upArrow READ upArrow WRITE setUpArrow)
    Q_PROPERTY(Style upButton READ upButton WRITE setUpButton)
    
/*!
    \class SpinBoxStyle
    \brief SpinBoxStyle is a styling component for SpinBox
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-style
    
    \sa SpinBox
*/

/*!
    \property Style SpinBoxStyle::downArrow
    \brief Applies styling properties to the down arrow of the SpinBox
*/

/*!
    \property Style SpinBoxStyle::downButton
    \brief Applies styling properties to the down button of the SpinBox
*/

/*!
    \property Style SpinBoxStyle::upArrow
    \brief Applies styling properties to the up arrow of the SpinBox
*/

/*!
    \property Style SpinBoxStyle::upButton
    \brief Applies styling properties to the up button of the SpinBox
*/

};

#endif // SPINBOXSTYLE_P_H

