/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef REPEATER_P_H
#define REPEATER_P_H

class Repeater
{

    Q_PROPERTY(Object parent READ parent WRITE setParent)
    Q_PROPERTY(variant model READ model WRITE setModel)
    Q_PROPERTY(Component delegate READ delegate WRITE setDelegate)
    Q_PROPERTY(int count READ count)

public:
    Item itemAt(int index);

signals:
    void itemAdded(int index, Item item);
    void itemRemoved(int index, Item item);

/*!
    \class Repeater
    \brief The Repeater component creates items from a data model
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-positioning
*/

/*!
    \property Object Repeater::parent
    \brief The parent of the repeater
*/

/*!
    \property variant Repeater::model
    \brief The model used to create items
    
    The model can be any of the following types:
    
    \li \c int
    \li \c string
    \li \c list
    \li \c stringlist
    \li \c ListModel
    \li \c QAbstractItemModel

    \sa ListModel
*/

/*!
    \property Component Repeater::delegate
    \brief The component from which items are to be created
*/

/*!
    \property int Repeater::count
    \brief The number of items created
*/

/*!
    \fn Item Repeater::itemAt(int index)
    
    Returns the item at \e index, if it exists. 
    Otherwise \c null is returned.
*/

/*!
    \fn void Repeater::itemAdded(int index, Item item)
    
    This signal is emitted when an item is created and 
    added to the parent layout.
*/

/*!
    \fn void Repeater::itemRemoved(int index, Item item)
    
    This signal is emitted when an item is removed and is 
    about to be deleted.
*/

};

#endif // REPEATER_P_H
