/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef PAGESTACK_P_H
#define PAGESTACK_P_H

class PageStack
{

    Q_PROPERTY(int depth READ depth)
    Q_PROPERTY(Page currentPage READ currentPage)

public:
    void push(Page page);
    void push(url source);
    void push(url source, jsobject properties);

    void pop();
    void pop(Page page);
    void pop(string objectName);
    
/*!
    \class PageStack
    \brief PageStack is a stack of pages in a Window
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-controls
    
    Each Window in an application has a pageStack property. 
    Pages can be pushed/popped to/from the stack by calling 
    the appropriate functions.
    
    Pushing a page:
    
    \code
    Window {
        id: window
        
        Button {
            anchors.centerIn: parent
            text: "Push a page"
            onClicked: pageStack.push(Qt.resolvedUrl("SomePage.qml"))
        }
    }
    \endcode
    
    Popping a page:
    
    \code
    Page {
        id: page
        
        Button {
            anchors.centerIn: parent
            text: "Pop this page"
            onClicked: pageStack.pop()
        }
    }
    \endcode
    
    \note A PageStack is automatically created for each 
    Window in the application. PageStack cannot be created 
    in QML.
    
    \sa Page, Window
*/

/*!
    \property int PageStack::depth
    \brief The number of pages in the stack
*/

/*!
    \property Page PageStack::currentPage
    \brief The current page in the stack
*/

/*!
    \fn void PageStack::push(Page page)
    
    Pushes \a page onto the stack and 
    sets \a page to be the current page.
*/

/*!
    \fn void PageStack::push(url source)
    
    Loads a page from \a source and pushes 
    the resulting Page onto the stack.
*/

/*!
    \fn void PageStack::push(url source, jsobject properties)
    
    Loads a page from \a source and sets \a properties. 
    The resulting Page is pushed onto the stack.
*/

/*!
    \fn void PageStack::pop()
    
    Pops the current page from the stack.
*/

/*!
    \fn void PageStack::pop(Page page)
    
    Pops all pages above \a page from the stack.
*/

/*!
    \fn void PageStack::pop(string objectName)
    
    Pops all pages above that with object name 
    \a objectName from the stack.
*/

};

#endif // PAGESTACK_P_H
