/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MODELINDEX_P_H
#define MODELINDEX_P_H

class QModelIndex
{

public:
    bool isValid(QModelIndex index);

    int row(QModelIndex index);
    int column(QModelIndex index);

    variant model(QModelIndex index);

    variant data(QModelIndex index, int role = Qt.DisplayRole);
    variant data(QModelIndex index, string roleName);

    flags flags(QModelIndex index);

    QModelIndex parent(QModelIndex index);
    QModelIndex child(QModelIndex index, int row, int column);
    QModelIndex sibling(QModelIndex index, int row, int column);

/*!
    \class QModelIndex
    \brief QModelIndex is a global context property providing access to the 
    properties of a QModelIndex
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-properties
    \ingroup org-hildon-components-data
    
    \note QModelIndex is a global context property and cannot be created in QML.
    
    \sa ListModel, ListView, TableView, TreeView
*/

/*!
    \fn void bool QModelIndex::isValid(QModelIndex index)
    
    Returns true if the \a index is valid.
*/

/*!
    \fn void int QModelIndex::row(QModelIndex index)
    
    Returns the row of \a index.
*/

/*!
    \fn void int QModelIndex::column(QModelIndex index)
    
    Returns the column of \a index.
*/

/*!
    \fn void variant QModelIndex::model(QModelIndex index)
    
    Returns the model of \a index.
*/

/*!
    \fn void variant QModelIndex::data(QModelIndex index, int role)
    
    Returns the data of \a index with \a role.
*/

/*!
    \fn void variant QModelIndex::data(QModelIndex index, string roleName)
    
    Returns the data of \a index with \a roleName.
*/

/*!
    \fn void flags QModelIndex::flags(QModelIndex index)
    
    Returns the item flags of \a index.
*/

/*!
    \fn void QModelIndex QModelIndex::parent(QModelIndex index)
    
    Returns the parent QModelIndex of \a index.
*/

/*!
    \fn void QModelIndex QModelIndex::child(QModelIndex index, int r, int c)
    
    Returns the child QModelIndex of \a index with row \a r and column \a c.
*/

/*!
    \fn void QModelIndex QModelIndex::sibling(QModelIndex index, int r, int c)
    
    Returns the sibling QModelIndex of \a index with row \a r and column \a c.
*/

};

#endif // MODELINDEX_P_H
