/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MENUSTYLE_P_H
#define MENUSTYLE_P_H

class MenuStyle : public Style
{
    
    Q_PROPERTY(Style indicator READ indicator WRITE setIndicator)
    Q_PROPERTY(Style item READ item WRITE setItem)
    Q_PROPERTY(Style leftArrow READ leftArrow WRITE setLeftArrow)
    Q_PROPERTY(Style rightArrow READ rightArrow WRITE setRightArrow)
    Q_PROPERTY(Style scroller READ scroller WRITE setScroller)
    Q_PROPERTY(Style separator READ separator WRITE setSeparator)
    Q_PROPERTY(Style tearoff READ tearoff WRITE setTearoff)
    
/*!
    \class MenuStyle
    \brief MenuStyle is a styling component for Menu
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-style
    
    \sa Menu
*/

/*!
    \property Style MenuStyle::indicator
    \brief Applies styling properties to the indicator of the Menu
*/

/*!
    \property Style MenuStyle::item
    \brief Applies styling properties to items in the Menu
*/

/*!
    \property Style MenuStyle::leftArrow
    \brief Applies styling properties to the left arrow of the Menu
*/

/*!
    \property Style MenuStyle::rightArrow
    \brief Applies styling properties to the right arrow of the Menu
*/

/*!
    \property Style MenuStyle::scroller
    \brief Applies styling properties to the scroller of the Menu
*/

/*!
    \property Style MenuStyle::separator
    \brief Applies styling properties to separators in the Menu
*/

/*!
    \property Style MenuStyle::tearoff
    \brief Applies styling properties to the tearoff of the Menu
*/

};

#endif // MENUSTYLE_P_H

