/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef LOADER_P_H
#define LOADER_P_H

class Loader
{

    Q_PROPERTY(Object parent READ parent WRITE setParent)
    Q_PROPERTY(url source READ source WRITE setSource)
    Q_PROPERTY(Component sourceComponent READ sourceComponent WRITE setSourceComponent)
    Q_PROPERTY(Item item READ item)
    Q_PROPERTY(enumeration status READ status)
    Q_PROPERTY(real progress READ progress)

signals:
    void loaded();
    
/*!
    \class Loader
    \brief The Loader component is used for dynamically loading an item from a Component
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-utility
    
    The component used to load the item can either be defined inline, 
    or specified as a url to a QML file:
    
    \code
    Page {
        id: page
        
        Column {
        
            Button {
                id: button
                
                text: "Load dialog from inline component"
                onClicked: {
                    loader.sourceComponent = dialogComponent;
                    loader.item.open();
                }
            }
            
            Button {
                id: button
                
                text: "Load dialog from url"
                onClicked: {
                    loader.source = Qt.resolvedUrl("MyDialog.qml");
                    loader.item.open();
                }
            }
        }
        
        Component {
            id: dialogComponent
            
            Dialog {
                id: dialog
                
                windowTitle: "Dynamically loaded dialog"
                content: Label {
                    anchors.fill: parent
                    alignment: Qt.AlignCenter
                    text: "This dialog was loaded dynamically using a Loader."
                }
                buttons: Button {
                    text: "Done"
                    onClicked: dialog.accept()
                }
            }
        }
    }
    \endcode
    
    MyDialog.qml:
    
    \code
    Dialog {
        id: dialog
        
        windowTitle: "Dynamically loaded dialog"
        content: Label {
            anchors.fill: parent
            alignment: Qt.AlignCenter
            text: "This dialog was loaded dynamically using a Loader."
        }
        buttons: Button {
            text: "Done"
            onClicked: dialog.accept()
        }
    }
    \endcode
*/

/*!
    \property Object Loader::parent
    \brief The parent object of the loader
*/

/*!
    \property url Loader::source
    \brief The url used to load the item
*/

/*!
    \property Component Loader::sourceComponent
    \brief The inline component used to load the item
*/

/*!
    \property Item Loader::item
    \brief The item loaded from the component
*/

/*!
    \property enumeration Loader::status
    \brief The current status of the loader
*/

/*!
    \property real Loader::progress
    \brief The current progress of the loader
*/

};

#endif // LOADER_P_H
