/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef LISTVIEWSTYLE_P_H
#define LISTVIEWSTYLE_P_H

class ListViewStyle : public FlickableStyle
{
    
    Q_PROPERTY(Style item READ item WRITE setItem)
    Q_PROPERTY(color alternateBackgroundColor READ alternateBackgroundColor WRITE setAlternateBackgroundColor)
    Q_PROPERTY(color selectionBackgroundColor READ selectionBackgroundColor WRITE setSelectionBackgroundColor)
    Q_PROPERTY(color selectionColor READ selectionColor WRITE setSelectionColor)
    Q_PROPERTY(bool showDecorationSelected READ showDecorationSelected WRITE setShowDecorationSelected)
    
/*!
    \class ListViewStyle
    \brief ListViewStyle is a styling component for ListView
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-style
    
    \sa ListView
*/

/*!
    \property Style ListViewStyle::item
    \brief Applies styling properties to the list view's items
*/

/*!
    \property color ListViewStyle::alternateBackgroundColor
    \brief Sets the alternate background color of ListView

    This property only takes effect if ListView::alternatingRowColors 
    is set to \a true.
*/

/*!
    \property color ListViewStyle::selectionBackgroundColor
    \brief Sets the background color of selected items in the ListView
*/

/*!
    \property color ListViewStyle::selectionColor
    \brief Sets the foreground color of selected items in the ListView
*/

/*!
    \property bool ListViewStyle::showDecorationSelected
    \brief Insert description here
*/

};

#endif // LISTVIEWSTYLE_P_H

