/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef LISTITEMPROGRESSBAR_P_H
#define LISTITEMPROGRESSBAR_P_H

class ListItemProgressBar : public ListItemContent
{

    Q_PROPERTY(int minimum READ minimum WRITE setMinimum)
    Q_PROPERTY(int maximum READ maximum WRITE setMaximum)
    Q_PROPERTY(string text READ text)
    Q_PROPERTY(int value READ value WRITE setValue)
    Q_PROPERTY(flags alignment READ alignment WRITE setAlignment)
    Q_PROPERTY(bool textVisible READ isTextVisible WRITE setTextVisible)
    Q_PROPERTY(enumeration orientation READ orientation WRITE setOrientation)
    Q_PROPERTY(bool invertedAppearance READ invertedAppearance WRITE setInvertedAppearance)
    Q_PROPERTY(enumeration textDirection READ textDirection WRITE setTextDirection)
    Q_PROPERTY(string format READ format WRITE setFormat)

/*!
    \class ListItemProgressBar
    \brief The ListItemProgressBar component displays a progress bar in ListItem

    \ingroup org-hildon-components
    \ingroup org-hildon-components-views

    \sa ListItem, ProgressBar
*/

/*!
    \property int ListItemProgressBar::minimum
    \brief The progress bar's minimum value

    When setting this property, the \link maximum\endlink is adjusted if
    necessary to ensure that the range remains valid.
*/

/*!
    \property int ListItemProgressBar::maximum
    \brief The progress bar's maximum value

    When setting this property, the \link minimum\endlink is adjusted if
    necessary to ensure that the range remains valid.
*/

/*!
    \property int ListItemProgressBar::value
    \brief The progress bar's current value

    Attempting to change the current value to one outside
    the minimum-maximum range has no effect on the current value.
*/

/*!
    \property bool ListItemProgressBar::textVisible
    \brief Whether the current completed percentage should be displayed

    \sa textDirection
*/

/*!
    \property flags ListItemProgressBar::alignment
    \brief The alignment of the progress bar
*/

/*!
    \property string ListItemProgressBar::text
    \brief The descriptive text shown with the progress bar

    The text returned is the same as the text displayed in the center
    (or in some styles, to the left) of the progress bar.

    The progress shown in the text may be smaller than the minimum value,
    indicating that the progress bar is in the "reset" state before any
    progress is set.

    In the default implementation, the text either contains a percentage
    value that indicates the progress so far, or it is blank because the
    progress bar is in the reset state.
*/

/*!
    \property enumeration ListItemProgressBar::orientation
    \brief the orientation of the progress bar

    The orientation must be \c Qt.Horizontal (the default) or \c
    Qt.Vertical.

    \sa invertedAppearance, textDirection
*/

/*!
    \property bool ListItemProgressBar::invertedAppearance
    \brief Whether or not a progress bar shows its progress inverted

    If this property is false, the progress bar grows in the other
    direction (e.g. from right to left). By default, the progress bar
    is not inverted.

    \sa orientation, layoutDirection
*/

/*!
    \property enumeration ListItemProgressBar::textDirection
    \brief The reading direction of the \link text\endlink for vertical progress bars
    
    Possible values are:
    
    \li \c TopToBottom
    \li \c BottomToTop

    This property has no impact on horizontal progress bars.
    By default, the reading direction is \c TopToBottom.

    \sa orientation, textVisible
*/

/*!
    \property string ListItemProgressBar::format
    \brief The string used to generate the current text

    %p - is replaced by the percentage completed.
    %v - is replaced by the current value.
    %m - is replaced by the total number of steps.

    The default value is "%p%".

    \sa text
*/

};

#endif // LISTITEMPROGRESSBAR_P_H
