/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef LISTITEMLABEL_P_H
#define LISTITEMLABEL_P_H

class ListItemLabel : public ListItemContent
{
    
    Q_PROPERTY(color color READ color WRITE setColor)
    Q_PROPERTY(font font READ font WRITE setFont)
    Q_PROPERTY(flags alignment READ alignment WRITE setAlignment)
    Q_PROPERTY(bool wordWrap READ wordWrap WRITE setWordWrap)
    Q_PROPERTY(string text READ text WRITE setText)
    
/*!
    \class ListItemLabel
    \brief The ListItemLabel component displays text in ListItem
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-views
    
    \sa ListItem, Label
*/

/*!
    \property color ListItemLabel::color
    \brief The color of the text
*/

/*!
    \property font ListItemLabel::font
    \brief The font of the text
*/

/*!
    \property string ListItemLabel::text
    \brief The label's text

    Setting the text clears any previous content.

    \sa alignment
*/

/*!
    \property flags ListItemLabel::alignment
    \brief The alignment of the label's contents

    By default, the contents of the label are left-aligned and vertically-centered.

    \sa text
*/

/*!
    \property bool ListItemLabel::wordWrap
    \brief The label's word-wrapping policy

    If this property is true then label text is wrapped where
    necessary at word-breaks; otherwise it is not wrapped at all.

    By default, word wrap is disabled.

    \sa text
*/

};

#endif // LISTITEMLABEL_P_H
