/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef LISTELEMENT_P_H
#define LISTELEMENT_P_H

class ListElement
{
    
/*!
    \class ListElement
    \brief The ListElement component represents an element in a ListModel
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-data
    
    The names of properties declared in the ListElement can 
    be used to access data in the ListModel:
    
    \code
    ListModel {
        id: model
        
        ListElement { 
            property string name: "foo"
            property string value: "bar"
        }
        
        Component.onCompleted: {
            console.log(model.property(model.modelIndex(0), "name")); // "foo"
            console.log(model.get(model.modelIndex(0)).value); // "bar"
        }
    }
    \endcode
    
    \sa ListModel, ListView
*/

};

#endif // LISTELEMENT_P_H

