/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */
 
#ifndef FOLDERDIALOG_P_H
#define FOLDERDIALOG_P_H

class FolderDialog : public Dialog
{

    Q_PROPERTY(string rootPath READ rootPath WRITE setRootPath)
    Q_PROPERTY(bool showDirs READ showDirs WRITE setShowDirs)
    Q_PROPERTY(bool showHidden READ showHidden WRITE setShowHidden)
    Q_PROPERTY(bool showSymlinks READ showSymlinks WRITE setShowSymlinks)
    Q_PROPERTY(bool resolveSymlinks READ resolveSymlinks WRITE setResolveSymlinks)
    Q_PROPERTY(bool readOnly READ readOnly WRITE setReadOnly)
    Q_PROPERTY(bool nameFilterDisables READ nameFilterDisables WRITE setNameFilterDisables)
    Q_PROPERTY(stringlist nameFilters READ nameFilters WRITE setNameFilters)
    
public:
    void cd(string path);
    void cdUp();
    
signals:
    void selected(string folder);
    
/*!
    \class FolderDialog
    \brief The FolderDialog component provides a folder browser dialog with read/write access
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-dialogs
    
    A FolderDialog can be used to enable the user to choose 
    either an existing folder, or create a new one.
    
    \code
    Window {
        id: window
        
        Button {
            anchors.centerIn: parent
            text: "Show folder browser"
            onClicked: folderBrowser.open()
        }
        
        FolderDialog {
            id: folderBrowser
            
            onSelected: console.log("Folder selected: " + folder)
        }
    }
    \endcode
*/

/*!
    \property string FolderDialog::rootPath
    \brief The root path of the model
    
    \sa FileSystemModel::rootPath
*/

/*!
    \property bool FolderDialog::showDirs
    \brief Whether the model should include directories
    
    \sa FileSystemModel::showDirs
*/

/*!
    \property bool FolderDialog::showHidden
    \brief Whether the model should include hidden files
    
    \sa FileSystemModel::showHidden
*/

/*!
    \property bool FolderDialog::showSymlinks
    \brief Whether the model should include symlinks
    
    \sa FileSystemModel::showSymlinks
*/

/*!
    \property bool FolderDialog::resolveSymlinks
    \brief Whether the model should resolve symlinks
    
    \sa FileSystemModel::resolveSymlinks
*/

/*!
    \property bool FolderDialog::readOnly
    \brief Whether the model should be read-only
    
    If this property is set to false, it will be possible 
    to create new folders from within the dialog.
    
    \sa FileSystemModel::readOnly
*/

/*!
    \property bool FolderDialog::nameFilterDisables
    \brief Whether files that do not match the filter will be disabled 
    or removed
    
    \sa FileSystemModel::nameFilterDisables
*/

/*!
    \property stringlist FolderDialog::nameFilters
    \brief The list of name filters used by the model
    
    \sa FileSystemModel::nameFilters
*/

/*!
    \fn void FolderDialog::cd(string path)
    
    Changes the current directory to \a path.
*/

/*!
    \fn void FolderDialog::cdUp()
    
    Changes the current directory to the parent directory.
*/

/*!
    \fn void FolderDialog::selected(string folder)
    
    This signal is emitted when the user chooses a folder.
*/

};

#endif // FOLDERDIALOG_P_H
