/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef FLOW_P_H
#define FLOW_P_H

class Flow : public Item
{

    Q_PROPERTY(int spacing READ spacing WRITE setSpacing)

/*!
    \class Flow
    \brief The Flow component provides a wrapping layout for 
    visual items

    \ingroup org-hildon-components
    \ingroup org-hildon-components-positioning
    
    Visual items declared as children of the Flow are automatically 
    added to the layout:
    
    \code
    Flow {
        
        Button {
            text: "Button one"
        }
        
        Button {
            text: "Button two"
        }
        
        Button {
            text: "Button three"
        }
    }
    \endcode
*/

/*!
    \property int Flow::spacing
    
    Determines the spacing between items 
    in the layout.
*/

};

#endif // FLOW_P_H
