/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef FLICKABLESTYLE_P_H
#define FLICKABLESTYLE_P_H

class FlickableStyle : public Style
{
    Q_OBJECT
    
    Q_PROPERTY(enumeration backgroundAttachment READ backgroundAttachment WRITE setBackgroundAttachment NOTIFY changed)
    
/*!
    \class FlickableStyle
    \brief FlickableStyle is a styling component for Flickable

    \ingroup org-hildon-components
    \ingroup org-hildon-components-style
    
    \sa Flickable
*/

/*!
    \property enumeration FlickableStyle::backgroundAttachment
    \brief Sets the behaviour of the background image
    
    Possible values are:
    
    \li \c Scroll - The background image is scrolled along 
    with the Flickable.
    \li \c Fixed - The background image does not scroll.
    
    The default value is \c Scroll.
*/

};

#endif // FLICKABLESTYLE_P_H

