/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef FLICKABLE_P_H
#define FLICKABLE_P_H

class Flickable : public Item
{

    Q_PROPERTY(enumeration verticalScrollBarPolicy READ verticalScrollBarPolicy WRITE setVerticalScrollBarPolicy)
    Q_PROPERTY(enumeration horizontalScrollBarPolicy READ horizontalScrollBarPolicy WRITE setHorizontalScrollBarPolicy)
    Q_PROPERTY(bool interactive READ interactive WRITE setInteractive)
    Q_PROPERTY(bool moving READ moving)
    Q_PROPERTY(bool atXBeginning READ atXBeginning)
    Q_PROPERTY(bool atXEnd READ atXEnd)
    Q_PROPERTY(bool atYBeginning READ atYBeginning)
    Q_PROPERTY(bool atYEnd READ atYEnd)
    Q_PROPERTY(int contentX READ contentX WRITE setContentX)
    Q_PROPERTY(int contentY READ contentY WRITE setContentY)
    Q_PROPERTY(real flickDeceleration READ flickDeceleration WRITE setFlickDeceleration)
    Q_PROPERTY(real maximumFlickVelocity READ maximumFlickVelocity WRITE setMaximumFlickVelocity)

/*!
    \class Flickable
    \brief The Flickable component provides a scrolling view onto
    another item

    \ingroup org-hildon-components
    \ingroup org-hildon-components-controls

    A scroll area is used to display the contents of a child item
    within a frame. If the item exceeds the size of the frame, the
    view can provide scroll bars so that the entire area of the child
    item can be viewed.

    The scroll bars appearance depends on the currently set 
    horizontalScrollBarPolicy and verticalScrollBarPolicy properties. 
*/

/*!
    \property enumeration Flickable::verticalScrollBarPolicy
    \brief The policy for the vertical scroll bar
    
    The possible values are:
    
    \li \c Qt.ScrollBarAlwaysOn
    \li \c Qt.ScrollBarAlwaysOff
    \li \c Qt.ScrollBarAsNeeded

    The default policy is Qt.ScrollBarAsNeeded.

    \sa horizontalScrollBarPolicy
*/

/*!
    \property enumeration Flickable::horizontalScrollBarPolicy
    \brief The policy for the horizontal scroll bar
    
    The possible values are:
    
    \li \c Qt.ScrollBarAlwaysOn
    \li \c Qt.ScrollBarAlwaysOff
    \li \c Qt.ScrollBarAsNeeded

    The default policy is Qt.ScrollBarAsNeeded.

    \sa verticalScrollBarPolicy
*/

/*!
    \property bool Flickable::interactive
    \brief Whether the Flickable responds to gestures
*/

/*!
    \property bool Flickable::moving
    \brief Whether the Flickable is currently scrolling
*/

/*!
    \property bool Flickable::atXBeginning
    \brief Whether the Flickable's \e x position is the minimum
*/

/*!
    \property bool Flickable::atXEnd
    \brief Whether the Flickable's \e x position is the maximum
*/

/*!
    \property bool Flickable::atYBeginning
    \brief Whether the Flickable's \e y position is the minimum
*/

/*!
    \property bool Flickable::atYEnd
    \brief Whether the Flickable's \e y position is the maximum
*/

/*!
    \property int Flickable::contentX
    \brief The Flickable's \e x position
*/

/*!
    \property int Flickable::contentY
    \brief The Flickable's \e y position
*/

/*!
    \property real Flickable::flickDeceleration
    \brief The Flickable's rate of deceleration after a flick gesture
*/

/*!
    \property real Flickable::maximumFlickVelocity
    \brief The maximum velocity allowed for the Flickable when flicked
*/

};

#endif // FLICKABLE_P_H
