/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */
 
#ifndef FILEDIALOG_P_H
#define FILEDIALOG_P_H

class FileDialog : public Dialog
{

    Q_PROPERTY(string rootPath READ rootPath WRITE setRootPath)
    Q_PROPERTY(bool showDirs READ showDirs WRITE setShowDirs)
    Q_PROPERTY(bool showHidden READ showHidden WRITE setShowHidden)
    Q_PROPERTY(bool showSymlinks READ showSymlinks WRITE setShowSymlinks)
    Q_PROPERTY(bool resolveSymlinks READ resolveSymlinks WRITE setResolveSymlinks)
    Q_PROPERTY(bool nameFilterDisables READ nameFilterDisables WRITE setNameFilterDisables)
    Q_PROPERTY(stringlist nameFilters READ nameFilters WRITE setNameFilters)
    
public:
    void cd(string path);
    void cdUp();
    
signals:
    void selected(string filePath);
    
/*!
    \class FileDialog
    \brief The FileDialog component provides a read-only file chooser dialog
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-dialogs
    
    \code
    Window {
        id: window
        
        Button {
            anchors.centerIn: parent
            text: "Show file browser"
            onClicked: fileBrowser.open()
        }
        
        FileDialog {
            id: fileBrowser
            
            onSelected: console.log("File selected: " + filePath)
        }
    }
    \endcode
*/

/*!
    \property string FileDialog::rootPath
    \brief The root path of the model
    
    \sa FileSystemModel::rootPath
*/

/*!
    \property bool FileDialog::showDirs
    \brief Whether the model should include directories
    
    \sa FileSystemModel::showDirs
*/

/*!
    \property bool FileDialog::showHidden
    \brief Whether the model should include hidden files
    
    \sa FileSystemModel::showHidden
*/

/*!
    \property bool FileDialog::showSymlinks
    \brief Whether the model should include symlinks
    
    \sa FileSystemModel::showSymlinks
*/

/*!
    \property bool FileDialog::resolveSymlinks
    \brief Whether the model should resolve symlinks
    
    \sa FileSystemModel::resolveSymlinks
*/

/*!
    \property bool FileDialog::nameFilterDisables
    \brief Whether files that do not match the filter will be disabled 
    or removed
    
    \sa FileSystemModel::nameFilterDisables
*/

/*!
    \property stringlist FileDialog::nameFilters
    \brief The list of name filters used by the model
    
    \sa FileSystemModel::nameFilters
*/

/*!
    \fn void FileDialog::cd(string path)
    
    Changes the current directory to \a path.
*/

/*!
    \fn void FileDialog::cdUp()
    
    Changes the current directory to the parent directory.
*/

/*!
    \fn void FileDialog::selected(string filePath)
    
    This signal is emitted when the user chooses a file.
*/

};

#endif // FILEDIALOG_P_H
