/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef EDITBAR_P_H
#define EDITBAR_P_H

class EditBar : public Item
{

    Q_PROPERTY(string text READ text WRITE setText)

/*!
    \class EditBar
    \brief The EditBar component provides an edit toolbar
    showing a label and an arbitrary number of buttons.
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-controls
    
    The edit bar component is used to implement the Hildon edit-toolbar 
    functionality a full screen Page or Window.
    
    To add a button to the edit bar, simply declare it as a child:
    
    \code
    Page {
        id: editPage
        
        fullScreen: true
    
        EditBar {
            anchors {
                left: parent.left
                right: parent.right
                top: parent.top
            }
            text: "Edit items"
            
            Button {
                text: "Done"
                onClicked: confirmEdit()
            }
        }
    }
    \endcode
    
    \sa Button, Page, Window
*/

/*!
    \property string EditBar::text
    \brief The text shown on the edit bar
    
    The default value is an empty string
*/

};

#endif // EDITBAR_P_H
