import QtQuick 1.0

SelectionButton {
    id: root

    property variant model
    property int selectedIndex

    signal valueChosen(variant value)

    QtObject {
        id: internal

        function setInitialValue() {
            var found = false;
            var i = 0;

            while ((!found) && (i < model.count)) {
                if (model.get(i).value === value) {
                    selectedIndex = i;
                    found = true;
                }

                i++;
            }

            if (found) {
                valueText = model.get(selectedIndex).name;
            }
        }
    }

    onClicked: {
        loader.sourceComponent = selectionDialog;
        loader.item.open();
    }

    Loader {
        id: loader
    }

    Component {
        id: selectionDialog

        SelectionDialog {
            titleText: root.text
            model: root.model
            selectedIndex: root.selectedIndex
            onAccepted: {
                root.value = model.get(selectedIndex).value;
                root.valueText = model.get(selectedIndex).name;
                root.selectedIndex = selectedIndex
                root.valueChosen(root.value);
            }
        }
    }

    Component.onCompleted: if (model) internal.setInitialValue();
}
