import QtQuick 1.0

Dialog {
    id: root

    property string rejectButtonText
    property alias labelText: label.text
    property alias minimumValue: progressBar.minimumValue
    property alias maximumValue: progressBar.maximumValue
    property alias value: progressBar.value
    property bool cancelled: internal.cancelled

    modal: true
    height: column.height + 50
    content: Item {
        anchors.fill: parent

        Column {
            id: column

            anchors {
                left: parent.left
                right: parent.right
                top: parent.top
            }
            spacing: platformStyle.paddingSmall

            Label {
                id: label

                width: parent.width
                wrapMode: Text.WordWrap
                visible: text != ""
            }

            ProgressBar {
                id: progressBar

                width: parent.width
                minimumValue: 0
                maximumValue: 100
                visible: maximumValue > 0
                onValueChanged: if (value >= maximumValue) root.accept();
            }
        }
    }

    buttons: Loader {
        id: buttonLoader

        sourceComponent: rejectButtonText == "" ? undefined : rejectButton
    }

    onRejected: internal.cancelled = true
    onOpened: internal.cancelled = false

    QtObject {
        id: internal

        property bool cancelled: false
    }

    Component {
        id: rejectButton

        DialogButton {
            text: rejectButtonText
            onClicked: root.reject()
        }
    }
}
